/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sourceforge.jwbf.core.NotReleased;
import net.sourceforge.jwbf.core.internal.Checked;
import org.apache.commons.lang3.StringEscapeUtils;

public final class MediaWiki {
    static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final String URL_API = "/api.php";
    public static final String URL_INDEX = "/index.php";
    public static final int NS_MAIN = 0;
    public static final int NS_MAIN_TALK = 1;
    public static final int NS_USER = 2;
    public static final int NS_USER_TALK = 3;
    public static final int NS_META = 4;
    public static final int NS_META_TALK = 5;
    public static final int NS_IMAGES = 6;
    public static final int NS_IMAGES_TALK = 7;
    public static final int NS_MEDIAWIKI = 8;
    public static final int NS_MEDIAWIKI_TALK = 9;
    public static final int NS_TEMPLATE = 10;
    public static final int NS_TEMPLATE_TALK = 11;
    public static final int NS_HELP = 12;
    public static final int NS_HELP_TALK = 13;
    public static final int NS_CATEGORY = 14;
    public static final int NS_CATEGORY_TALK = 15;
    public static final ImmutableList<Integer> NS_EVERY = ImmutableList.builder().add((Object)0).add((Object)1).add((Object)2).add((Object)3).add((Object)4).add((Object)5).add((Object)6).add((Object)7).add((Object)8).add((Object)9).add((Object)10).add((Object)11).add((Object)12).add((Object)13).add((Object)14).add((Object)15).build();
    @Deprecated
    public static final int[] NS_ALL = Ints.toArray(NS_EVERY);
    public static final Set<String> BOT_GROUPS = ImmutableSet.of((Object)"bot");

    static Field getFieldUnchecked(Class<?> clazz, String fieldName) {
        try {
            return clazz.getField(fieldName);
        }
        catch (NoSuchFieldException nsfe) {
            throw new IllegalArgumentException(nsfe);
        }
    }

    private MediaWiki() {
    }

    public static String getCharset() {
        return CHARSET.displayName();
    }

    public static String urlEncode(String s) {
        return MediaWiki.urlEncodeUnchecked(s, MediaWiki.getCharset());
    }

    static String urlEncodeUnchecked(String in, String charset) {
        try {
            return URLEncoder.encode(Checked.nonNull(in, "in"), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String urlDecode(String s) {
        return MediaWiki.urlDecodeUnchecked(s, MediaWiki.getCharset());
    }

    static String urlDecodeUnchecked(String in, String charset) {
        try {
            return URLDecoder.decode(Checked.nonNull(in, "in"), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String htmlUnescape(String s) {
        return StringEscapeUtils.unescapeHtml4((String)s);
    }

    @Deprecated
    public static String createNsString(int ... namespaces) {
        return MediaWiki.createNsString(MediaWiki.nullSafeCopyOf(namespaces));
    }

    public static ImmutableList<String> nullSafeCopyOf(@Nullable String[] strings) {
        if (strings == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Object[])strings);
    }

    @Nonnull
    public static ImmutableList<Integer> nullSafeCopyOf(@Nullable int[] ints) {
        if (ints == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)Ints.asList((int[])ints));
    }

    public static String createNsString(List<Integer> asList) {
        return Joiner.on((String)"|").join(asList);
    }

    public static String urlEncodedNamespace(ImmutableList<Integer> namespaces) {
        return MediaWiki.urlEncode(MediaWiki.createNsString(namespaces));
    }

    public static enum Version {
        UNKNOWN,
        MW1_14,
        MW1_15,
        MW1_16,
        MW1_17,
        MW1_18,
        MW1_19,
        MW1_20,
        MW1_21,
        MW1_22,
        MW1_23,
        MW1_24,
        MW1_25,
        DEVELOPMENT;

        private static final ImmutableList<Version> STABLE_VERSIONS;
        private static final Version LATEST_VERSION;

        public String getNumber() {
            return this.name().replace("MW", "").replace("_0", "_").replace("_", ".");
        }

        public String getNumberVariation() {
            return this.getNumber().replace(".", "-");
        }

        private int getIntValue() {
            try {
                return Integer.parseInt(this.getNumber().replace(".", ""));
            }
            catch (NumberFormatException e) {
                if (this == DEVELOPMENT) {
                    return Integer.MAX_VALUE;
                }
                return -1;
            }
        }

        public static Version getLatest() {
            return LATEST_VERSION;
        }

        @VisibleForTesting
        public static boolean isStableVersion(Version version) {
            if (version != null) {
                Field field = Version.getField(version);
                boolean isDeprecated = field.isAnnotationPresent(Deprecated.class);
                boolean isBeta = field.isAnnotationPresent(NotReleased.class);
                return !version.equals((Object)DEVELOPMENT) && !version.equals((Object)UNKNOWN) && !isDeprecated && !isBeta;
            }
            return false;
        }

        public boolean greaterEqThen(Version v) {
            return v.getIntValue() <= this.getIntValue();
        }

        public static ImmutableList<Version> valuesStable() {
            return STABLE_VERSIONS;
        }

        static Field getField(Version version) {
            return MediaWiki.getFieldUnchecked(Version.class, version.name());
        }

        static {
            STABLE_VERSIONS = FluentIterable.from(Arrays.asList(Version.values())).filter((Predicate)new Predicate<Version>(){

                public boolean apply(@Nullable Version version) {
                    return Version.isStableVersion(version);
                }
            }).toSortedList((Comparator)new Comparator<Version>(){

                @Override
                public int compare(Version o1, Version o2) {
                    return Integer.valueOf(o1.getIntValue()).compareTo(o2.getIntValue());
                }
            });
            LATEST_VERSION = (Version)((Object)Iterables.getLast(Version.valuesStable()));
        }
    }
}

