/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.editing;

import com.google.common.base.Optional;
import com.google.common.collect.Queues;
import java.util.Deque;
import net.sourceforge.jwbf.core.actions.Post;
import net.sourceforge.jwbf.core.actions.RequestBuilder;
import net.sourceforge.jwbf.core.actions.util.ActionException;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.editing.GetApiToken;
import net.sourceforge.jwbf.mediawiki.actions.util.ApiException;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import net.sourceforge.jwbf.mediawiki.contentRep.SimpleFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUpload
extends MWAction {
    private static final Logger log = LoggerFactory.getLogger(FileUpload.class);
    private final Deque<HttpAction> actions;
    private UploadAction actionHandler;

    public FileUpload(SimpleFile simpleFile, MediaWikiBot bot) {
        if (!simpleFile.isFile() || !simpleFile.canRead()) {
            throw new IllegalArgumentException("no such file " + simpleFile.getFile());
        }
        if (!bot.isLoggedIn()) {
            throw new ActionException("Please login first");
        }
        if (!simpleFile.exists()) {
            throw new IllegalArgumentException("file not found " + simpleFile.getFile());
        }
        this.actionHandler = new ApiUpload(simpleFile, bot.getVersion());
        this.actions = this.actionHandler.getActions();
    }

    public FileUpload(MediaWikiBot bot, String filename) {
        this(new SimpleFile(filename), bot);
    }

    @Override
    public HttpAction getNextMessage() {
        return this.actions.pop();
    }

    @Override
    public boolean hasMoreMessages() {
        return !this.actions.isEmpty();
    }

    @Override
    public String processReturningText(String xml, HttpAction hm) {
        return this.actionHandler.handleResponse(xml, hm);
    }

    private static interface UploadAction {
        public Deque<HttpAction> getActions();

        public String handleResponse(String var1, HttpAction var2);
    }

    private static class ApiUpload
    implements UploadAction {
        private final Deque<HttpAction> actions = Queues.newArrayDeque();
        private final SimpleFile simpleFile;
        private final MediaWiki.Version version;
        private GetApiToken uploadTokenAction;

        public ApiUpload(SimpleFile simpleFile, MediaWiki.Version version) {
            this.simpleFile = simpleFile;
            this.version = version;
        }

        @Override
        public Deque<HttpAction> getActions() {
            this.uploadTokenAction = new GetApiToken(GetApiToken.Intoken.EDIT, this.simpleFile.getTitle());
            this.actions.add(this.uploadTokenAction.popAction());
            return this.actions;
        }

        @Override
        public String handleResponse(String xml, HttpAction hm) {
            log.debug("{}", (Object)xml);
            XmlElement doc = XmlConverter.getRootElementWithError(xml);
            Optional exceptionOptional = doc.getErrorElement().transform(XmlConverter.toApiException());
            if (exceptionOptional.isPresent()) {
                throw (ApiException)exceptionOptional.get();
            }
            if (this.uploadTokenAction != null) {
                this.uploadTokenAction.processReturningText(xml, hm);
                RequestBuilder requestBuilder = new ApiRequestBuilder().action("upload").formatXml().param("filename", MediaWiki.urlEncode(this.simpleFile.getTitle())).postParam("text", this.simpleFile.getText()).postParam(this.uploadTokenAction.get().token()).param("ignorewarnings", true).postParam("file", this.simpleFile.getFile());
                Post upload = requestBuilder.buildPost();
                this.actions.add(upload);
                this.uploadTokenAction = null;
            }
            return xml;
        }
    }
}

