/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.editing;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Nonnull;
import net.sourceforge.jwbf.core.Optionals;
import net.sourceforge.jwbf.core.actions.Get;
import net.sourceforge.jwbf.core.actions.ParamTuple;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.core.internal.NonnullFunction;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.util.DequeMWAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetApiToken
extends DequeMWAction<TokenResponse> {
    private static final Logger log = LoggerFactory.getLogger(GetApiToken.class);
    private static final ImmutableMap<Intoken, Function<XmlElement, String>> TOKEN_FUNCTIONS = ImmutableMap.builder().put((Object)Intoken.DELETE, GetApiToken.tokenFunctionOf("deletetoken")).put((Object)Intoken.EDIT, GetApiToken.tokenFunctionOf("edittoken")).put((Object)Intoken.MOVE, GetApiToken.tokenFunctionOf("movetoken")).put((Object)Intoken.PROTECT, GetApiToken.tokenFunctionOf("protecttoken")).put((Object)Intoken.EMAIL, GetApiToken.tokenFunctionOf("emailtoken")).put((Object)Intoken.BLOCK, GetApiToken.tokenFunctionOf("blocktoken")).put((Object)Intoken.UNBLOCK, GetApiToken.tokenFunctionOf("unblocktoken")).put((Object)Intoken.IMPORT, GetApiToken.tokenFunctionOf("IMPORT")).build();
    private Optional<String> token = Optional.absent();
    private final Intoken intoken;
    private final HttpAction msg;

    @Override
    public TokenResponse get() {
        return new TokenResponse(){

            @Override
            @Nonnull
            @Deprecated
            public ParamTuple<String> urlEncodedToken() {
                return new ParamTuple<String>("token", MediaWiki.urlEncode(this.getToken()));
            }

            private String getToken() {
                return (String)Optionals.getOrThrow(GetApiToken.this.token, "The argument 'token' is missing");
            }

            @Override
            @Nonnull
            public ParamTuple<String> token() {
                return new ParamTuple<String>("token", this.getToken());
            }
        };
    }

    public GetApiToken(Intoken intoken, String title) {
        super(GetApiToken.generateTokenRequest(intoken, title));
        this.intoken = intoken;
        this.msg = (HttpAction)this.actions.getFirst();
    }

    private static Get generateTokenRequest(Intoken intoken, String title) {
        return new ApiRequestBuilder().action("query").formatXml().param("prop", "info").param("intoken", intoken.toString().toLowerCase()).param("titles", MediaWiki.urlEncode(title)).buildGet();
    }

    @Override
    public void processReturningText(String s, HttpAction hm) {
        if (hm.getRequest().equals(this.msg.getRequest())) {
            log.debug("Got returning text: \"{}\"", (Object)s);
            try {
                Optional<XmlElement> elem = XmlConverter.getChildOpt(s, "query", "pages", "page");
                this.token = elem.transform((Function)TOKEN_FUNCTIONS.get((Object)this.intoken));
                log.debug("urlEncodedToken = {} for: {}", this.token, (Object)this.msg.getRequest());
            }
            catch (IllegalArgumentException e) {
                if (s.startsWith("unknown_action:")) {
                    log.error("Adding '$wgEnableWriteAPI = true;' to your MediaWiki's LocalSettings.php might remove this problem.", (Throwable)e);
                }
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static Function<XmlElement, String> tokenFunctionOf(final String key) {
        return new NonnullFunction<XmlElement, String>(){

            @Override
            @Nonnull
            public String applyNonnull(@Nonnull XmlElement xmlElement) {
                return xmlElement.getAttributeValueNonNull(key);
            }
        };
    }

    public static enum Intoken {
        DELETE,
        EDIT,
        MOVE,
        PROTECT,
        EMAIL,
        BLOCK,
        UNBLOCK,
        IMPORT;

    }

    public static interface TokenResponse {
        @Deprecated
        public ParamTuple<String> urlEncodedToken();

        public ParamTuple<String> token();
    }
}

