/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.editing;

import net.sourceforge.jwbf.core.actions.Get;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.core.contentRep.SimpleArticle;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRevision
extends MWAction {
    private static final Logger log = LoggerFactory.getLogger(GetRevision.class);
    private final SimpleArticle sa;
    public static final int CONTENT = 2;
    public static final int TIMESTAMP = 4;
    public static final int USER = 8;
    public static final int COMMENT = 16;
    public static final int IDS = 32;
    public static final int FLAGS = 64;
    public static final int FIRST = 0x40000000;
    public static final int LAST = Integer.MIN_VALUE;
    private final int properties;
    private final Get msg;
    private boolean singleProcess = true;

    public GetRevision(MediaWiki.Version v, String articlename, int properties) {
        this.properties = properties;
        this.sa = new SimpleArticle();
        this.sa.setTitle(articlename);
        this.msg = new ApiRequestBuilder().action("query").formatXml().param("prop", "revisions").param("titles", MediaWiki.urlEncode(articlename)).param("rvprop", this.getDataProperties(properties) + this.getReversion(properties)).param("rvlimit", "1").buildGet();
    }

    @Override
    public String processReturningText(String s, HttpAction ha) {
        if (this.msg.getRequest().equals(ha.getRequest()) && this.singleProcess) {
            if (log.isDebugEnabled()) {
                if (s.length() < 151) {
                    log.debug(s);
                } else {
                    log.debug("..." + s.substring(50, 150) + "...");
                }
            }
            this.parse(s);
            this.singleProcess = false;
        }
        return "";
    }

    private String getDataProperties(int property) {
        String properties = "";
        if ((property & 2) > 0) {
            properties = properties + "content|";
        }
        if ((property & 0x10) > 0) {
            properties = properties + "comment|";
        }
        if ((property & 4) > 0) {
            properties = properties + "timestamp|";
        }
        if ((property & 8) > 0) {
            properties = properties + "user|";
        }
        if ((property & 0x20) > 0) {
            properties = properties + "ids|";
        }
        if ((property & 0x40) > 0) {
            properties = properties + "flags|";
        }
        if (properties.length() > 0) {
            return MediaWiki.urlEncode(properties.substring(0, properties.length() - 1));
        }
        return "";
    }

    private String getReversion(int property) {
        String properties = "&rvdir=";
        properties = (property & 0x40000000) > 0 ? properties + "newer" : properties + "older";
        return properties;
    }

    private void parse(String xml) {
        this.findContent(XmlConverter.getChecked(xml));
    }

    public SimpleArticle getArticle() {
        return this.sa;
    }

    private void findContent(XmlElement root) {
        for (XmlElement xmlElement : root.getChildren()) {
            if (xmlElement.getQualifiedName().equalsIgnoreCase("rev")) {
                this.sa.setText(xmlElement.getText());
                if ((this.properties & 0x40) > 0) {
                    if (xmlElement.hasAttribute("minor")) {
                        this.sa.setMinorEdit(true);
                    } else {
                        this.sa.setMinorEdit(false);
                    }
                }
                this.sa.setRevisionId((String)xmlElement.getAttributeValueOpt("revid").or((Object)""));
                this.sa.setEditSummary((String)xmlElement.getAttributeValueOpt("comment").or((Object)""));
                this.sa.setEditor((String)xmlElement.getAttributeValueOpt("user").or((Object)""));
                if ((this.properties & 4) <= 0) continue;
                this.sa.setEditTimestamp((String)xmlElement.getAttributeValueOpt("timestamp").or((Object)""));
                continue;
            }
            this.findContent(xmlElement);
        }
    }

    @Override
    public HttpAction getNextMessage() {
        return this.msg;
    }
}

