/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.editing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.Set;
import net.sourceforge.jwbf.core.actions.RequestBuilder;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.core.actions.util.PermissionException;
import net.sourceforge.jwbf.core.internal.Checked;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.editing.GetApiToken;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MovePage
extends MWAction {
    private static final Logger log = LoggerFactory.getLogger(MovePage.class);
    private final String oldtitle;
    private final String newtitle;
    private final String reason;
    private final boolean withsubpages;
    private final boolean noredirect;
    private final GetApiToken token;
    private boolean moveToken = true;

    public MovePage(MediaWikiBot bot, String oldtitle, String newtitle, String reason, boolean withsubpages, boolean noredirect) {
        this.token = new GetApiToken(GetApiToken.Intoken.MOVE, oldtitle);
        this.oldtitle = Checked.nonBlank(oldtitle, "oldtitle");
        this.newtitle = Checked.nonBlank(newtitle, "newtitle");
        this.reason = reason;
        this.withsubpages = withsubpages;
        this.noredirect = noredirect;
        this.checkPermissions(bot.getUserinfo().getRights(), withsubpages);
    }

    @VisibleForTesting
    void checkPermissions(Set<String> permissions, boolean withSubPages) {
        if (!permissions.contains("move")) {
            throw new PermissionException("The given user doesn't have the rights to move. Add '$wgGroupPermissions['bot']['move'] = true;' to your MediaWikis LocalSettings.php might solve this problem.");
        }
        if (withSubPages && !permissions.contains("move-subpages")) {
            throw new PermissionException("The given user doesn't have the rights to move subpages. Add '$wgGroupPermissions['bot']['move-subpages'] = true;' to your MediaWikis LocalSettings.php might solve this problem.");
        }
    }

    private HttpAction getSecondRequest() {
        RequestBuilder requestBuilder = new ApiRequestBuilder().action("move").formatXml().param("from", MediaWiki.urlEncode(this.oldtitle)).param("to", MediaWiki.urlEncode(this.newtitle)).postParam(this.token.get().token()).param("movetalk", "");
        if (this.withsubpages) {
            requestBuilder.param("movesubpages", "");
        }
        if (this.noredirect) {
            requestBuilder.param("noredirect", "");
        }
        if (!Strings.isNullOrEmpty((String)this.reason)) {
            requestBuilder.param("reason", MediaWiki.urlEncode(this.reason));
        }
        return requestBuilder.buildPost();
    }

    @Override
    public String processReturningText(String xml, HttpAction hm) {
        XmlConverter.failOnError(xml);
        if (this.moveToken) {
            this.token.processReturningText(xml, hm);
            this.moveToken = false;
        } else {
            log.debug("Got returning text: \"{}\"", (Object)xml);
            this.setHasMoreMessages(false);
        }
        return "";
    }

    @Override
    public HttpAction getNextMessage() {
        if (this.token.hasMoreActions()) {
            this.setHasMoreMessages(true);
            return this.token.popAction();
        }
        return this.getSecondRequest();
    }
}

