/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.editing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import net.sourceforge.jwbf.core.actions.Post;
import net.sourceforge.jwbf.core.actions.RequestBuilder;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.core.actions.util.PermissionException;
import net.sourceforge.jwbf.core.actions.util.ProcessException;
import net.sourceforge.jwbf.core.contentRep.Userinfo;
import net.sourceforge.jwbf.core.internal.Checked;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.editing.GetApiToken;
import net.sourceforge.jwbf.mediawiki.actions.util.ApiException;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostDelete
extends MWAction {
    private static final Logger log = LoggerFactory.getLogger(PostDelete.class);
    private final String title;
    private final String reason;
    private final GetApiToken tokenAction;
    private boolean delToken = true;

    @Deprecated
    public PostDelete(Userinfo userinfo, String title) {
        this(userinfo, title, null);
    }

    public PostDelete(Userinfo userinfo, String title, String reason) {
        this.title = Checked.nonBlank(title, "title");
        if (!userinfo.getRights().contains("delete")) {
            throw new PermissionException("The given user doesn't have the rights to delete. Add '$wgGroupPermissions['bot']['delete'] = true;' to your MediaWiki's LocalSettings.php might solve this problem.");
        }
        this.tokenAction = new GetApiToken(GetApiToken.Intoken.DELETE, title);
        this.reason = Strings.emptyToNull((String)reason);
    }

    private HttpAction getSecondRequest() {
        log.trace("enter PostDelete.generateDeleteRequest(String)");
        RequestBuilder requestBuilder = new ApiRequestBuilder().action("delete").formatXml().postParam(this.tokenAction.get().token()).param("title", MediaWiki.urlEncode(this.title));
        if (this.reason != null) {
            requestBuilder.param("reason", MediaWiki.urlEncode(this.reason));
        }
        Post msg = requestBuilder.buildPost();
        log.debug("delete url: \"{}\"", (Object)msg.getRequest());
        return msg;
    }

    @Override
    public String processReturningText(String s, HttpAction hm) {
        super.processReturningText(s, hm);
        if (this.delToken) {
            this.tokenAction.processReturningText(s, hm);
            this.delToken = false;
        } else {
            this.parseXml(s);
            this.setHasMoreMessages(false);
        }
        return "";
    }

    @VisibleForTesting
    void parseXml(String xml) {
        log.debug("Got returning text: \"{}\"", (Object)xml);
        try {
            XmlElement doc = XmlConverter.getRootElementWithError(xml);
            Optional exceptionOptional = doc.getErrorElement().transform(XmlConverter.toApiException());
            if (exceptionOptional.isPresent()) {
                ApiException apiException = (ApiException)exceptionOptional.get();
                String code = apiException.getCode();
                if ("missingtitle".equals(code)) {
                    log.warn("{}", (Object)apiException.getValue());
                } else {
                    if ("inpermissiondenied".equals(code)) {
                        log.error("Adding '$wgGroupPermissions['bot']['delete'] = true;' to your MediaWiki's LocalSettings.php might remove this problem.");
                        throw apiException;
                    }
                    throw apiException;
                }
            }
            this.logDelete(doc);
        }
        catch (IllegalArgumentException e) {
            String msg = e.getMessage();
            log.error(msg, (Throwable)e);
            if (xml.startsWith("unknown_action:")) {
                String eMsg = "unknown_action; Adding '$wgEnableWriteAPI = true;' to your MediaWiki's LocalSettings.php might remove this problem.";
                throw new ProcessException(eMsg);
            }
            throw new ProcessException(msg);
        }
    }

    private void logDelete(XmlElement rootXmlElement) {
        XmlElement elem = rootXmlElement.getChild("delete");
        if (elem != XmlElement.NULL_XML) {
            String title = elem.getAttributeValue("title");
            String reason = elem.getAttributeValue("reason");
            this.logDeleted(title, reason);
        } else {
            log.error("Unknow reply. This is not a reply for a delete action.");
        }
    }

    @VisibleForTesting
    void logDeleted(String title, String reason) {
        log.debug("Deleted article '{}'  with reason '{}'", (Object)title, (Object)reason);
    }

    @Override
    public HttpAction getNextMessage() {
        if (this.tokenAction.hasMoreActions()) {
            this.setHasMoreMessages(true);
            return this.tokenAction.popAction();
        }
        return this.getSecondRequest();
    }
}

