/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.editing;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Set;
import net.sourceforge.jwbf.core.actions.Post;
import net.sourceforge.jwbf.core.actions.RequestBuilder;
import net.sourceforge.jwbf.core.actions.util.ActionException;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.core.contentRep.ContentAccessable;
import net.sourceforge.jwbf.core.contentRep.SimpleArticle;
import net.sourceforge.jwbf.core.contentRep.Userinfo;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.editing.GetApiToken;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import net.sourceforge.jwbf.mediawiki.actions.util.VersionException;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostModifyContent
extends MWAction {
    private static final Logger log = LoggerFactory.getLogger(PostModifyContent.class);
    private boolean first = true;
    private boolean second = true;
    private final ContentAccessable a;
    private final MediaWikiBot bot;
    private GetApiToken editTokeAction = null;
    private HttpAction apiGet = null;
    private Post editRequest = null;
    static final String PARAM_MINOR = "minor";
    static final String PARAM_MINOR_NOT = "notminor";
    static final String PARAM_BOTEDIT = "bot";

    public PostModifyContent(MediaWikiBot bot, SimpleArticle a) {
        if (Strings.isNullOrEmpty((String)a.getTitle())) {
            throw new ActionException("imposible request, no title");
        }
        this.a = a;
        this.bot = bot;
    }

    @Override
    public HttpAction getNextMessage() {
        boolean canWrite;
        Userinfo userinfo = this.bot.getUserinfo();
        Set<String> rights = userinfo.getRights();
        boolean bl = canWrite = rights.contains("edit") && rights.contains("writeapi");
        if (!canWrite) {
            throw new VersionException("editing is not allowed");
        }
        if (this.first) {
            this.first = false;
            this.editTokeAction = this.newTokenRequest();
            this.apiGet = this.editTokeAction.popAction();
            return this.apiGet;
        }
        if (this.second) {
            RequestBuilder builder = new ApiRequestBuilder().action("edit").formatXml().param("title", MediaWiki.urlEncode(this.a.getTitle())).postParam("summary", this.a.getEditSummary()).postParam("text", this.a.getText());
            Set<String> groups = userinfo.getGroups();
            if (!this.isIntersectionEmpty(groups, MediaWiki.BOT_GROUPS)) {
                builder.postParam(PARAM_BOTEDIT, "");
            }
            if (this.a.isMinorEdit()) {
                builder.postParam(PARAM_MINOR, "");
            } else {
                builder.postParam(PARAM_MINOR_NOT, "");
            }
            builder.postParam(this.editTokeAction.get().token());
            this.second = false;
            this.editRequest = builder.buildPost();
            return this.editRequest;
        }
        throw new IllegalStateException("this action has only two messages");
    }

    GetApiToken newTokenRequest() {
        return new GetApiToken(GetApiToken.Intoken.EDIT, this.a.getTitle());
    }

    @Override
    public boolean hasMoreMessages() {
        return this.first || this.second;
    }

    @Override
    public String processReturningText(String xml, HttpAction hm) {
        String request = hm.getRequest();
        if (request.equals(this.apiGet.getRequest())) {
            this.editTokeAction.processReturningText(xml, hm);
        } else if (request.equals(this.editRequest.getRequest())) {
            XmlConverter.getRootElement(xml);
        } else {
            log.trace(xml);
            throw new ActionException("unknown response");
        }
        return xml;
    }

    boolean isIntersectionEmpty(Set<?> a, Set<?> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Sets.SetView intersection = Sets.intersection(a, b);
        return intersection.isEmpty();
    }
}

