/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.login;

import net.sourceforge.jwbf.core.actions.Post;
import net.sourceforge.jwbf.core.actions.RequestBuilder;
import net.sourceforge.jwbf.core.actions.util.ActionException;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.core.actions.util.PermissionException;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import net.sourceforge.jwbf.mediawiki.contentRep.LoginData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostLogin
extends MWAction {
    private static final Logger log = LoggerFactory.getLogger(PostLogin.class);
    private Post msg;
    private final String success = "Success";
    private final String wrongPass = "WrongPass";
    private final String notExists = "NotExists";
    private final String needToken = "NeedToken";
    private LoginData login = new LoginData();
    private boolean reTry = false;
    private boolean reTryLimit = true;
    private final String username;
    private final String pw;
    private final String domain;

    public PostLogin(String username, String pw, String domain) {
        this.username = username;
        this.pw = pw;
        this.domain = domain;
        this.msg = this.getLoginMsg(username, pw, domain, null);
    }

    private Post getLoginMsg(String username, String pw, String domain, String token) {
        RequestBuilder loginRequest = new ApiRequestBuilder().action("login").formatXml().postParam("lgname", username).postParam("lgpassword", pw);
        if (domain != null) {
            loginRequest.postParam("lgdomain", domain);
        }
        if (token != null) {
            loginRequest.postParam("lgtoken", token);
        }
        return loginRequest.buildPost();
    }

    @Override
    public String processAllReturningText(String s) {
        XmlElement root = XmlConverter.getRootElement(s);
        this.findContent(root);
        return s;
    }

    private void findContent(XmlElement startXmlElement) {
        String result = startXmlElement.getChildAttributeValue("login", "result");
        if (result.equalsIgnoreCase("Success")) {
            this.login.setup(startXmlElement.getChildAttributeValue("login", "lgusername"), true);
        } else if (result.equalsIgnoreCase("NeedToken") && this.reTryLimit) {
            this.msg = this.getLoginMsg(this.username, this.pw, this.domain, startXmlElement.getChildAttributeValue("login", "token"));
            this.reTry = true;
            this.reTryLimit = false;
        } else {
            if (result.equalsIgnoreCase("WrongPass")) {
                throw new PermissionException("Wrong Password");
            }
            if (result.equalsIgnoreCase("NotExists")) {
                throw new ActionException("No such User");
            }
            if (result.equalsIgnoreCase("Throttled")) {
                throw new ActionException("Throttled");
            }
        }
    }

    @Override
    public HttpAction getNextMessage() {
        return this.msg;
    }

    @Override
    public boolean hasMoreMessages() {
        boolean temp = super.hasMoreMessages() || this.reTry;
        this.reTry = false;
        return temp;
    }

    public LoginData getLoginData() {
        return this.login;
    }
}

