/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.meta;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import net.sourceforge.jwbf.core.actions.Get;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.core.contentRep.Userinfo;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetUserinfo
extends MWAction
implements Userinfo {
    private static final Logger log = LoggerFactory.getLogger(GetUserinfo.class);
    private String username = "";
    private final Set<String> rights = Sets.newHashSet();
    private final Set<String> groups = Sets.newHashSet();
    private final Get msg;

    public GetUserinfo() {
        String properties = MediaWiki.urlEncode("blockinfo|hasmsg|groups|rights|options|editcount|ratelimits");
        this.msg = new ApiRequestBuilder().action("query").formatXml().param("meta", "userinfo").param("uiprop", properties).buildGet();
    }

    private void parse(String xml) {
        log.debug(xml);
        this.rights.clear();
        this.groups.clear();
        this.findContent(XmlConverter.getRootElement(xml));
    }

    @Override
    public final String processAllReturningText(String s) {
        this.parse(s);
        return "";
    }

    public ImmutableSet<String> getRights() {
        return ImmutableSet.copyOf(this.rights);
    }

    public ImmutableSet<String> getGroups() {
        return ImmutableSet.copyOf(this.groups);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    protected void findContent(XmlElement root) {
        for (XmlElement xmlElement : root.getChildren()) {
            if (this.hasName(xmlElement, "userinfo")) {
                this.username = xmlElement.getAttributeValue("name");
            } else if (this.hasName(xmlElement, "groups")) {
                for (XmlElement groupElement : xmlElement.getChildren("g")) {
                    this.groups.add(groupElement.getText());
                }
            } else if (this.hasName(xmlElement, "rights")) {
                for (XmlElement rightElement : xmlElement.getChildren("r")) {
                    this.rights.add(rightElement.getText());
                }
            }
            this.findContent(xmlElement);
        }
    }

    private boolean hasName(XmlElement xmlElement, String elementName) {
        return xmlElement.getQualifiedName().equals(elementName);
    }

    @Override
    public HttpAction getNextMessage() {
        return this.msg;
    }
}

