/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.meta;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Set;
import net.sourceforge.jwbf.JWBF;
import net.sourceforge.jwbf.core.actions.Get;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetVersion
extends MWAction {
    private static final Logger log = LoggerFactory.getLogger(GetVersion.class);
    private final Get msg = new ApiRequestBuilder().action("query").formatXml().param("meta", "siteinfo").buildGet();
    private String generator = "";
    private String sitename = "";
    private String base = "";
    private String theCase = "";
    private String mainpage = "";
    public static final Set<String> GENERATOR_EXT = Sets.newHashSet();

    private void parse(String xml) {
        XmlElement rootElement = XmlConverter.getRootElementWithError(xml);
        this.findContent(rootElement);
    }

    @Override
    public final String processAllReturningText(String s) {
        this.parse(s);
        return "";
    }

    public String getSitename() {
        return this.sitename;
    }

    public String getBase() {
        return this.base;
    }

    public String getCase() {
        return this.theCase;
    }

    public MediaWiki.Version getVersion() {
        for (String generatorFragment : GENERATOR_EXT) {
            if (!this.getGenerator().contains(generatorFragment)) continue;
            return MediaWiki.Version.DEVELOPMENT;
        }
        for (MediaWiki.Version version : MediaWiki.Version.values()) {
            if (!this.getGenerator().contains(version.getNumber())) continue;
            return version;
        }
        if (log.isDebugEnabled()) {
            log.debug("\nVersion is UNKNOWN for JWBF (" + JWBF.getVersion(this.getClass()) + ") : \n\t" + this.getGenerator() + "\n\t" + "supported versions: " + Joiner.on((String)" ").join((Object[])MediaWiki.Version.values()) + "\n\t" + "\n\tUsing settings for actual Wikipedia development version");
        }
        return MediaWiki.Version.UNKNOWN;
    }

    public String getGenerator() {
        return this.generator;
    }

    public String getMainpage() {
        return this.mainpage;
    }

    protected void findContent(XmlElement root) {
        for (XmlElement xmlElement : root.getChildren()) {
            if (xmlElement.getQualifiedName().equalsIgnoreCase("general")) {
                this.mainpage = xmlElement.getAttributeValue("mainpage");
                this.base = xmlElement.getAttributeValue("base");
                this.sitename = xmlElement.getAttributeValue("sitename");
                this.generator = xmlElement.getAttributeValue("generator");
                this.theCase = xmlElement.getAttributeValue("case");
                continue;
            }
            this.findContent(xmlElement);
        }
    }

    @Override
    public HttpAction getNextMessage() {
        return this.msg;
    }

    static {
        GENERATOR_EXT.add("alpha");
        GENERATOR_EXT.add("wmf");
    }
}

