/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.meta;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.sourceforge.jwbf.core.actions.Get;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.meta.GetVersion;

public class Siteinfo
extends GetVersion {
    private final Get msg;
    private final Map<Integer, String> namespaces = Maps.newHashMap();
    private final Map<String, String> interwiki = Maps.newHashMap();
    public static final String GENERAL = "general";
    public static final String NAMESPACES = "namespaces";
    public static final String INTERWIKIMAP = "interwikimap";

    public Siteinfo() {
        this(GENERAL, NAMESPACES, INTERWIKIMAP);
    }

    public Siteinfo(String ... types) {
        String result = Joiner.on((String)"|").join((Object[])types);
        this.msg = new ApiRequestBuilder().action("query").formatXml().param("meta", "siteinfo").param("siprop", MediaWiki.urlEncode(result)).buildGet();
    }

    @Override
    public HttpAction getNextMessage() {
        return this.msg;
    }

    @Override
    protected void findContent(XmlElement root) {
        super.findContent(root);
        for (XmlElement xmlElement : root.getChildren()) {
            String name;
            if (xmlElement.getQualifiedName().equalsIgnoreCase("ns")) {
                Integer id = Integer.parseInt(xmlElement.getAttributeValue("id"));
                name = xmlElement.getText();
                this.namespaces.put(id, name);
                continue;
            }
            if (xmlElement.getQualifiedName().equalsIgnoreCase("iw")) {
                if (!xmlElement.hasAttribute("prefix")) continue;
                String prefix = xmlElement.getAttributeValue("prefix");
                name = xmlElement.getAttributeValue("url");
                this.interwiki.put(prefix, name);
                continue;
            }
            this.findContent(xmlElement);
        }
    }

    public ImmutableMap<Integer, String> getNamespaces() {
        return ImmutableMap.copyOf(this.namespaces);
    }

    public ImmutableMap<String, String> getInterwikis() {
        return ImmutableMap.copyOf(this.interwiki);
    }
}

