/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.misc;

import java.util.NoSuchElementException;
import net.sourceforge.jwbf.core.actions.Get;
import net.sourceforge.jwbf.core.actions.util.ActionException;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.core.actions.util.ProcessException;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRendering
extends MWAction {
    private static final Logger log = LoggerFactory.getLogger(GetRendering.class);
    private final Get msg;
    private String html = "";
    private final MediaWikiBot bot;
    private boolean isSelfEx = true;

    public GetRendering(MediaWikiBot bot, String wikitext) {
        this.bot = bot;
        this.msg = new ApiRequestBuilder().action("parse").formatXml().param("text", MediaWiki.urlEncode(wikitext)).param("title", "API").buildGet();
    }

    @Override
    @Deprecated
    public boolean isSelfExecuter() {
        return this.isSelfEx;
    }

    @Override
    public HttpAction getNextMessage() {
        return this.msg;
    }

    @Override
    public String processAllReturningText(String s) {
        this.html = this.findElement("text", s).getText();
        this.html = this.html.replace("\n", "");
        int last = this.html.lastIndexOf("<!--");
        this.html = this.html.substring(0, last);
        return "";
    }

    protected XmlElement findElement(String elementName, String xml) {
        XmlElement root = XmlConverter.getRootElement(xml);
        return this.findContent(root, elementName);
    }

    private XmlElement findContent(XmlElement e, String name) {
        XmlElement found = null;
        for (XmlElement xmlElement : e.getChildren()) {
            if (xmlElement.getQualifiedName().equalsIgnoreCase(name)) {
                return xmlElement;
            }
            found = this.findContent(xmlElement, name);
        }
        if (found == null) {
            throw new NoSuchElementException();
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        try {
            this.isSelfEx = false;
            this.bot.getPerformedAction(this);
        }
        catch (ActionException | ProcessException e) {
            log.warn("", (Throwable)e);
        }
        finally {
            this.isSelfEx = true;
        }
    }

    public String getHtml() {
        if (this.html.length() < 1) {
            this.update();
        }
        return this.html;
    }
}

