/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.queries;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import net.sourceforge.jwbf.core.actions.Get;
import net.sourceforge.jwbf.core.actions.RequestBuilder;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.queries.BaseQuery;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import net.sourceforge.jwbf.mediawiki.actions.util.RedirectFilter;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllPageTitles
extends BaseQuery<String> {
    private static final Logger log = LoggerFactory.getLogger(AllPageTitles.class);
    private static final int LIMIT = 50;
    private final String prefix;
    private final int[] namespaces;
    private final String from;
    private final RedirectFilter rf;

    public AllPageTitles(MediaWikiBot bot, String from, String prefix, RedirectFilter rf, int ... namespaces) {
        super(bot);
        this.rf = rf;
        this.prefix = prefix;
        this.namespaces = namespaces;
        this.from = from;
    }

    public AllPageTitles(MediaWikiBot bot, int ... namespaces) {
        this(bot, null, null, RedirectFilter.nonredirects, namespaces);
    }

    protected Get generateRequest(Optional<String> from, String prefix, RedirectFilter rf, String namespace) {
        RequestBuilder requestBuilder = new ApiRequestBuilder().action("query").paramNewContinue(this.bot().getVersion()).formatXml().param("list", "allpages").param("apfilterredir", this.findRedirectFilterValue(rf)).param("aplimit", 50);
        if (from.isPresent()) {
            requestBuilder.param("apfrom", MediaWiki.urlEncode((String)from.get()));
        }
        if (!Strings.isNullOrEmpty((String)prefix)) {
            requestBuilder.param("apprefix", MediaWiki.urlEncode(prefix));
        }
        if (!Strings.isNullOrEmpty((String)namespace)) {
            requestBuilder.param("apnamespace", MediaWiki.urlEncode(namespace));
        }
        return requestBuilder.buildGet();
    }

    protected String findRedirectFilterValue(RedirectFilter rf) {
        if (rf == RedirectFilter.all) {
            return "all";
        }
        if (rf == RedirectFilter.redirects) {
            return "redirects";
        }
        return "nonredirects";
    }

    @Override
    protected ImmutableList<String> parseElements(String s) {
        ImmutableList.Builder titles = ImmutableList.builder();
        Optional<XmlElement> child = XmlConverter.getChildOpt(s, "query", "allpages");
        if (child.isPresent()) {
            for (XmlElement pageElement : ((XmlElement)child.get()).getChildren("p")) {
                String title = pageElement.getAttributeValue("title");
                log.debug("Found article title: \"{}\"", (Object)title);
                titles.add((Object)title);
            }
        }
        return titles.build();
    }

    @Override
    protected Optional<String> parseHasMore(String xml) {
        return this.parseXmlHasMore(xml, "allpages", "apfrom", "apcontinue");
    }

    @Override
    protected HttpAction prepareNextRequest() {
        return this.generateRequest(this.nextPageInfoOpt(), this.prefix, this.rf, MWAction.createNsString(this.namespaces));
    }

    @Override
    protected Iterator<String> copy() {
        return new AllPageTitles(this.bot(), this.from, this.prefix, this.rf, this.namespaces);
    }
}

