/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.queries;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jwbf.core.actions.Get;
import net.sourceforge.jwbf.core.actions.RequestBuilder;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.core.internal.Checked;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.queries.BaseQuery;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import net.sourceforge.jwbf.mediawiki.actions.util.RedirectFilter;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BacklinkTitles
extends BaseQuery<String> {
    private static final Logger log = LoggerFactory.getLogger(BacklinkTitles.class);
    private final int backlinksPerRequestLimit;
    private final String articleName;
    private final MediaWikiBot bot;
    private final RedirectFilter redirectFilter;
    private final ImmutableList<Integer> namespaces;

    BacklinkTitles(MediaWikiBot bot, String articleName, int backlinksPerRequestLimit, RedirectFilter redirectFilter, ImmutableList<Integer> namespaces) {
        super(bot);
        this.backlinksPerRequestLimit = backlinksPerRequestLimit;
        this.bot = Checked.nonNull(bot, "bot");
        this.articleName = Checked.nonNull(articleName, "articleName");
        this.redirectFilter = Checked.nonNull(redirectFilter, "redirectFilter");
        this.namespaces = namespaces;
    }

    public BacklinkTitles(MediaWikiBot bot, String articleName, RedirectFilter redirectFilter, int ... namespaces) {
        this(bot, articleName, 50, redirectFilter, MWAction.nullSafeCopyOf(namespaces));
    }

    public BacklinkTitles(MediaWikiBot bot, String articleName) {
        this(bot, articleName, RedirectFilter.all, new int[0]);
    }

    @Override
    protected Iterator<String> copy() {
        return new BacklinkTitles(this.bot, this.articleName, this.backlinksPerRequestLimit, this.redirectFilter, this.namespaces);
    }

    @Override
    protected Optional<String> parseHasMore(String xml) {
        return this.parseXmlHasMore(xml, "backlinks", "blcontinue", "blcontinue");
    }

    @Override
    protected ImmutableList<String> parseElements(String xml) {
        Optional<XmlElement> child = XmlConverter.getChildOpt(xml, "query", "backlinks");
        ImmutableList.Builder titleCollection = ImmutableList.builder();
        if (child.isPresent()) {
            List<XmlElement> backlinks = ((XmlElement)child.get()).getChildren("bl");
            for (XmlElement backlink : backlinks) {
                titleCollection.add((Object)backlink.getAttributeValue("title"));
            }
        }
        return titleCollection.build();
    }

    private RequestBuilder newRequestBuilder(String title, RedirectFilter redirectFilter, ImmutableList<Integer> namespaces) {
        RequestBuilder builder = new ApiRequestBuilder().action("query").paramNewContinue(this.bot.getVersion()).formatXml().param("list", "backlinks").param("bllimit", this.backlinksPerRequestLimit).param("bltitle", MediaWiki.urlEncode(title)).param("blfilterredir", MediaWiki.urlEncode(redirectFilter.toString()));
        if (!namespaces.isEmpty()) {
            builder.param("blnamespace", MediaWiki.urlEncode(MWAction.createNsString(namespaces)));
        }
        return builder;
    }

    private Get newInitialRequest(String articleName, RedirectFilter redirectFilter, ImmutableList<Integer> namespace) {
        RequestBuilder requestBuilder = this.newRequestBuilder(articleName, redirectFilter, namespace);
        return requestBuilder.buildGet();
    }

    private Get newContinueRequest(String articleName, RedirectFilter redirectFilter, ImmutableList<Integer> namespaces, String blcontinue) {
        return this.newRequestBuilder(articleName, redirectFilter, namespaces).param("blcontinue", MediaWiki.urlEncode(blcontinue)).buildGet();
    }

    @Override
    protected HttpAction prepareNextRequest() {
        if (this.hasNextPageInfo()) {
            return this.newContinueRequest(this.articleName, this.redirectFilter, this.namespaces, this.getNextPageInfo());
        }
        return this.newInitialRequest(this.articleName, this.redirectFilter, this.namespaces);
    }
}

