/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.queries;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import net.sourceforge.jwbf.core.Optionals;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.core.internal.Checked;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseQuery<T>
implements Iterable<T>,
Iterator<T>,
Cloneable {
    private static final Logger log = LoggerFactory.getLogger(BaseQuery.class);
    private Iterator<T> titleIterator = ImmutableList.of().iterator();
    private final QueryAction inner;
    private final MediaWikiBot bot;
    private ImmutableList<T> oldTitlesForLogging = ImmutableList.of();
    private Optional<String> nextPageInfo = Optional.absent();

    protected final String setNextPageInfo(String nextPageInfo) {
        this.nextPageInfo = Optionals.absentIfEmpty(nextPageInfo);
        return nextPageInfo;
    }

    protected final String getNextPageInfo() {
        return (String)this.nextPageInfoOpt().get();
    }

    protected final Optional<String> nextPageInfoOpt() {
        return this.nextPageInfo;
    }

    protected boolean hasNextPageInfo() {
        return this.nextPageInfo.isPresent();
    }

    protected BaseQuery(MediaWikiBot bot) {
        this.bot = Checked.nonNull(bot, "bot");
        this.inner = this.getInnerAction();
    }

    private QueryAction getInnerAction() {
        return new QueryAction();
    }

    @Beta
    public Iterable<T> lazy() {
        return this;
    }

    @Beta
    public ImmutableList<T> getCopyOf(int count) {
        return ImmutableList.copyOf((Iterable)Iterables.limit(this.lazy(), (int)count));
    }

    @Override
    public final Iterator<T> iterator() {
        return this.copy();
    }

    protected abstract Iterator<T> copy();

    @Override
    public boolean hasNext() {
        this.doCollection();
        return this.titleIterator.hasNext();
    }

    @Override
    public T next() {
        this.doCollection();
        return this.titleIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("do not change this iteration");
    }

    @Deprecated
    protected Optional<String> parseXmlHasMore(String xml, String elementName, String attributeKey, String newContinueKey) {
        XmlElement rootElement = XmlConverter.getRootElement(xml);
        Optional<XmlElement> aContinue = rootElement.getChildOpt("continue");
        if (aContinue.isPresent()) {
            return ((XmlElement)aContinue.get()).getAttributeValueOpt(newContinueKey);
        }
        XmlElement queryContinue = rootElement.getChild("query-continue").getChild(elementName);
        return queryContinue.getAttributeValueOpt(attributeKey);
    }

    protected abstract HttpAction prepareNextRequest();

    private void doCollection() {
        if (this.inner.init || !this.titleIterator.hasNext() && this.hasNextPageInfo()) {
            this.inner.init = false;
            this.inner.setHasMoreMessages(true);
            this.inner.msg = this.prepareNextRequest();
            this.bot.getPerformedAction(this.inner);
        }
    }

    protected abstract ImmutableList<T> parseElements(String var1);

    protected abstract Optional<String> parseHasMore(String var1);

    protected MediaWikiBot bot() {
        return this.bot;
    }

    protected Object clone() throws CloneNotSupportedException {
        super.clone();
        throw new CloneNotSupportedException();
    }

    class QueryAction
    extends MWAction {
        private HttpAction msg;
        private boolean init = true;

        QueryAction() {
        }

        @Override
        public HttpAction getNextMessage() {
            return this.msg;
        }

        @Override
        public final String processAllReturningText(String s) {
            ImmutableList newTitles = BaseQuery.this.parseElements(s);
            BaseQuery.this.setNextPageInfo((String)BaseQuery.this.parseHasMore(s).orNull());
            if (log.isWarnEnabled()) {
                if (BaseQuery.this.oldTitlesForLogging.equals(newTitles) && !BaseQuery.this.oldTitlesForLogging.isEmpty()) {
                    log.warn("previous response has same payload");
                }
                BaseQuery.this.oldTitlesForLogging = newTitles;
            }
            BaseQuery.this.titleIterator = (Iterator)newTitles.iterator();
            return "";
        }
    }
}

