/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.queries;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.sourceforge.jwbf.core.actions.Get;
import net.sourceforge.jwbf.core.actions.RequestBuilder;
import net.sourceforge.jwbf.core.internal.Checked;
import net.sourceforge.jwbf.core.internal.NonnullFunction;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.queries.BaseQuery;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import net.sourceforge.jwbf.mediawiki.contentRep.CategoryItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CategoryMembers
extends BaseQuery<CategoryItem> {
    private static final Logger log = LoggerFactory.getLogger(CategoryMembers.class);
    protected static final int LIMIT = 50;
    final String categoryName;
    private final String namespaceStr;
    final ImmutableList<Integer> namespace;

    protected CategoryMembers(MediaWikiBot bot, String categoryName, ImmutableList<Integer> namespaces) {
        super(bot);
        this.namespace = Checked.nonNull(namespaces, "namespaces");
        this.namespaceStr = MWAction.createNsString(namespaces);
        this.categoryName = Checked.nonNull(categoryName, "categoryName").replace(" ", "_");
    }

    Get generateFirstRequest() {
        return this.newRequestBuilder().buildGet();
    }

    Get generateContinueRequest(String cmcontinue) {
        return this.newRequestBuilder().param("cmcontinue", MediaWiki.urlEncode(cmcontinue)).buildGet();
    }

    @Override
    public Optional<String> parseHasMore(String xml) {
        return this.parseXmlHasMore(xml, "categorymembers", "cmcontinue", "cmcontinue");
    }

    @Override
    public ImmutableList<CategoryItem> parseElements(String xml) {
        return this.parseArticles(xml, this.toCategoryItem());
    }

    private NonnullFunction<XmlElement, CategoryItem> toCategoryItem() {
        return new NonnullFunction<XmlElement, CategoryItem>(){

            @Override
            @Nonnull
            protected CategoryItem applyNonnull(@Nonnull XmlElement input) {
                String title = input.getAttributeValueNonNull("title");
                int namespace = Integer.parseInt(input.getAttributeValueNonNull("ns"));
                int pageId = Integer.parseInt(input.getAttributeValueNonNull("pageid"));
                return new CategoryItem(title, namespace, pageId);
            }
        };
    }

    <T> ImmutableList<T> parseArticles(String xml, NonnullFunction<XmlElement, T> f) {
        Optional<XmlElement> child = XmlConverter.getChildOpt(xml, "query", "categorymembers");
        if (child.isPresent()) {
            List<XmlElement> children = ((XmlElement)child.get()).getChildren();
            return FluentIterable.from(children).transform(f).toList();
        }
        return ImmutableList.of();
    }

    private RequestBuilder newRequestBuilder() {
        ApiRequestBuilder requestBuilder = new ApiRequestBuilder();
        if (this.namespaceStr.length() > 0) {
            requestBuilder.param("cmnamespace", MediaWiki.urlEncode(this.namespaceStr));
        }
        return requestBuilder.action("query").formatXml().paramNewContinue(this.bot().getVersion()).param("list", "categorymembers").param("cmlimit", 50).param("cmtitle", "Category:" + MediaWiki.urlEncode(this.categoryName));
    }
}

