/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.queries;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.core.internal.Checked;
import net.sourceforge.jwbf.core.internal.NonnullFunction;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.actions.queries.BaseQuery;
import net.sourceforge.jwbf.mediawiki.actions.queries.CategoryMembers;
import net.sourceforge.jwbf.mediawiki.actions.queries.CategoryMembersFull;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import net.sourceforge.jwbf.mediawiki.contentRep.CategoryItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryMembersSimple
extends BaseQuery<String> {
    private static final Logger log = LoggerFactory.getLogger(CategoryMembersSimple.class);
    private final CategoryMembers cm;

    @VisibleForTesting
    CategoryMembersSimple(MediaWikiBot bot, CategoryMembers cm) {
        super(bot);
        this.cm = Checked.nonNull(cm, "categoryMembers");
    }

    public CategoryMembersSimple(MediaWikiBot bot, String categoryName) {
        this(bot, categoryName, 0);
    }

    public CategoryMembersSimple(MediaWikiBot bot, String categoryName, int ... namespaces) {
        this(bot, new CategoryMembersFull(bot, categoryName, namespaces));
    }

    private CategoryMembersSimple(MediaWikiBot bot, String categoryName, ImmutableList<Integer> namespace) {
        this(bot, new CategoryMembersFull(bot, categoryName, namespace));
    }

    @Override
    protected HttpAction prepareNextRequest() {
        return this.cm.prepareNextRequest();
    }

    @Override
    protected ImmutableList<String> parseElements(String s) {
        return this.cm.parseArticles(s, CategoryMembersSimple.toTitleFunction());
    }

    @Override
    protected Optional<String> parseHasMore(String s) {
        return this.cm.parseHasMore(s);
    }

    @Override
    protected Iterator<String> copy() {
        return new CategoryMembersSimple(this.bot(), this.cm.categoryName, this.cm.namespace);
    }

    @Override
    public boolean hasNext() {
        return this.cm.hasNext();
    }

    @Override
    public String next() {
        return ((CategoryItem)this.cm.next()).getTitle();
    }

    static NonnullFunction<XmlElement, String> toTitleFunction() {
        return new NonnullFunction<XmlElement, String>(){

            @Override
            @Nonnull
            public String applyNonnull(@Nonnull XmlElement input) {
                return input.getAttributeValueNonNull("title");
            }
        };
    }
}

