/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.queries;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.imageio.ImageIO;
import net.sourceforge.jwbf.JWBF;
import net.sourceforge.jwbf.core.actions.Get;
import net.sourceforge.jwbf.core.actions.RequestBuilder;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.core.actions.util.ProcessException;
import net.sourceforge.jwbf.core.internal.Checked;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageInfo
extends MWAction {
    private static final Logger log = LoggerFactory.getLogger(ImageInfo.class);
    private static final Map<String, String> EMPTY_STRING_MAP = Collections.emptyMap();
    public static final String WIDTH = "iiurlwidth";
    public static final String HEIGHT = "iiurlheight";
    private String urlOfImage = "";
    private Get msg;
    private final MediaWikiBot bot;
    private boolean selfEx = true;
    private final ImmutableMap<String, String> params;
    private final String name;

    public ImageInfo(MediaWikiBot bot, String name) {
        this(bot, name, EMPTY_STRING_MAP);
    }

    public ImageInfo(MediaWikiBot bot, String name, Map<String, String> params) {
        this.bot = bot;
        this.name = name;
        this.params = ImmutableMap.copyOf(params);
        this.prepareMsg(name);
    }

    private void prepareMsg(String name) {
        int height;
        RequestBuilder requestBuilder = new ApiRequestBuilder().action("query").formatXml().param("iiprop", "url").param("prop", "imageinfo");
        int width = (Integer)this.intOrZero((String)this.params.get((Object)WIDTH)).or((Object)0);
        if (width > 0) {
            requestBuilder.param(WIDTH, width);
        }
        if ((height = ((Integer)this.intOrZero((String)this.params.get((Object)HEIGHT)).or((Object)0)).intValue()) > 0) {
            requestBuilder.param(HEIGHT, height);
        }
        requestBuilder.param("titles", "File:" + MediaWiki.urlEncode(name));
        this.msg = requestBuilder.buildGet();
    }

    private Optional<Integer> intOrZero(String string) {
        if (string == null) {
            return Optional.absent();
        }
        try {
            return Optional.of((Object)Integer.parseInt(string));
        }
        catch (NumberFormatException e) {
            log.warn("\"{}\" is not a number", (Object)string);
            return Optional.absent();
        }
    }

    public String getUrlAsString() {
        return this.getUrl().toExternalForm();
    }

    public URL getUrl() {
        String exceptionMsg = "no url for image with name \"" + this.name + "\"";
        try {
            this.selfEx = false;
            this.bot.getPerformedAction(this);
        }
        catch (ProcessException e) {
            throw ProcessException.joinMsgs(e, exceptionMsg);
        }
        finally {
            this.selfEx = true;
        }
        if (this.urlOfImage.length() < 1) {
            throw new ProcessException(exceptionMsg);
        }
        return JWBF.newURL(Checked.nonBlank(this.urlOfImage, "image url"));
    }

    @Override
    @Deprecated
    public boolean isSelfExecuter() {
        return this.selfEx;
    }

    public BufferedImage getAsImage() throws IOException {
        return ImageIO.read(this.getUrl());
    }

    @Override
    public String processAllReturningText(String xml) {
        Optional<XmlElement> child = XmlConverter.getChildOpt(xml, "query", "pages", "page", "imageinfo", "ii");
        if (child.isPresent()) {
            this.urlOfImage = (String)((XmlElement)child.get()).getAttributeValueOpt("url").or((Object)"");
        }
        return "";
    }

    @Override
    public HttpAction getNextMessage() {
        return this.msg;
    }
}

