/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.queries;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import net.sourceforge.jwbf.core.actions.RequestBuilder;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.queries.BaseQuery;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUsageTitles
extends BaseQuery<String> {
    private static final Logger log = LoggerFactory.getLogger(ImageUsageTitles.class);
    private final int limit;
    private final MediaWikiBot bot;
    private final String imageName;
    private final ImmutableList<Integer> namespaces;

    public ImageUsageTitles(MediaWikiBot bot, String imageName, int ... namespaces) {
        this(bot, 50, imageName, MWAction.nullSafeCopyOf(namespaces));
    }

    ImageUsageTitles(MediaWikiBot bot, int limit, String imageName, ImmutableList<Integer> namespaces) {
        super(bot);
        this.bot = bot;
        this.limit = limit;
        this.imageName = imageName;
        this.namespaces = namespaces;
    }

    public ImageUsageTitles(MediaWikiBot bot, String nextPageInfo) {
        this(bot, nextPageInfo, MediaWiki.NS_ALL);
    }

    @Override
    protected Optional<String> parseHasMore(String xml) {
        return this.parseXmlHasMore(xml, "imageusage", "iucontinue", "iucontinue");
    }

    @Override
    protected ImmutableList<String> parseElements(String s) {
        ImmutableList.Builder titleCollection = ImmutableList.builder();
        Optional<XmlElement> childOpt = XmlConverter.getChildOpt(s, "query", "imageusage");
        if (childOpt.isPresent()) {
            for (XmlElement element : ((XmlElement)childOpt.get()).getChildren("iu")) {
                titleCollection.add((Object)element.getAttributeValue("title"));
            }
        }
        return titleCollection.build();
    }

    @Override
    protected HttpAction prepareNextRequest() {
        RequestBuilder requestBuilder = new ApiRequestBuilder().action("query").paramNewContinue(this.bot.getVersion()).formatXml().param("iutitle", MediaWiki.urlEncode(this.imageName)).param("list", "imageusage").param("iulimit", this.limit).param("iunamespace", MediaWiki.urlEncodedNamespace(this.namespaces));
        Optional<String> ilcontinue = this.nextPageInfoOpt();
        if (ilcontinue.isPresent()) {
            requestBuilder.param("iucontinue", MediaWiki.urlEncode((String)ilcontinue.get()));
        }
        return requestBuilder.buildGet();
    }

    @Override
    protected Iterator<String> copy() {
        return new ImageUsageTitles(this.bot, this.limit, this.imageName, this.namespaces);
    }
}

