/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.queries;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.sourceforge.jwbf.core.actions.RequestBuilder;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.core.internal.NonnullFunction;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.queries.BaseQuery;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import net.sourceforge.jwbf.mediawiki.contentRep.LogItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogEvents
extends BaseQuery<LogItem> {
    private static final Logger log = LoggerFactory.getLogger(LogEvents.class);
    public static final String BLOCK = "block";
    public static final String PROTECT = "protect";
    public static final String RIGHTS = "rights";
    public static final String DELETE = "delete";
    public static final String UPLOAD = "upload";
    public static final String MOVE = "move";
    public static final String IMPORT = "import";
    public static final String PATROL = "patrol";
    public static final String MERGE = "merge";
    private final int limit;
    private final ImmutableList<String> type;

    public LogEvents(MediaWikiBot bot, String type) {
        this(bot, 50, (ImmutableList<String>)ImmutableList.of((Object)type));
    }

    @Deprecated
    public LogEvents(MediaWikiBot bot, String[] type) {
        this(bot, 50, type);
    }

    public LogEvents(MediaWikiBot bot, int limit, String first, String ... others) {
        this(bot, limit, (ImmutableList<String>)ImmutableList.builder().add((Object)first).addAll(MWAction.nullSafeCopyOf(others)).build());
    }

    @Deprecated
    public LogEvents(MediaWikiBot bot, int limit, String[] type) {
        this(bot, limit, MWAction.nullSafeCopyOf(type));
    }

    LogEvents(MediaWikiBot bot, int limit, ImmutableList<String> logtypes) {
        super(bot);
        this.type = logtypes;
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)("limit must be > 0, but was " + limit));
        this.limit = limit;
    }

    private RequestBuilder generateRequest(ImmutableList<String> logtypes) {
        RequestBuilder requestBuilder = new ApiRequestBuilder().action("query").paramNewContinue(this.bot().getVersion()).formatXml().param("list", "logevents").param("lelimit", this.limit);
        if (logtypes.size() > 0) {
            requestBuilder.param("letype", Joiner.on((String)"|").join(logtypes));
        }
        return requestBuilder;
    }

    @Override
    protected ImmutableList<LogItem> parseElements(String xml) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Optional<XmlElement> child = XmlConverter.getChildOpt(xml, "query", "logevents");
        if (child.isPresent()) {
            List<XmlElement> items = ((XmlElement)child.get()).getChildren("item");
            for (XmlElement item : items) {
                String title = item.getAttributeValue("title");
                String typeOf = item.getAttributeValue("type");
                String user = item.getAttributeValue("user");
                builder.add((Object)new LogItem(title, typeOf, user));
            }
        }
        return builder.build();
    }

    @Override
    protected Optional<String> parseHasMore(String s) {
        if (this.bot().getVersion().greaterEqThen(MediaWiki.Version.MW1_23)) {
            return this.parseXmlHasMore(s, "logevents", "lestart", "lecontinue");
        }
        log.warn("continuation is not supported");
        return Optional.absent();
    }

    @Override
    protected HttpAction prepareNextRequest() {
        if (this.hasNextPageInfo()) {
            return this.generateRequest(this.type).param("lecontinue", MediaWiki.urlEncode(this.getNextPageInfo())).buildGet();
        }
        return this.generateRequest(this.type).buildGet();
    }

    @Override
    protected Iterator<LogItem> copy() {
        return new LogEvents(this.bot(), this.limit, this.type);
    }

    static Function<LogItem, String> toTitles() {
        return new NonnullFunction<LogItem, String>(){

            @Override
            @Nonnull
            protected String applyNonnull(@Nonnull LogItem in) {
                return in.getTitle();
            }
        };
    }
}

