/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.queries;

import com.google.common.base.Optional;
import net.sourceforge.jwbf.core.Optionals;
import net.sourceforge.jwbf.core.actions.Get;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomPageTitle
extends MWAction {
    private static final Logger log = LoggerFactory.getLogger(RandomPageTitle.class);
    private final Get msg;
    private final MediaWikiBot bot;
    private Optional<String> title = Optional.absent();

    public RandomPageTitle(MediaWikiBot bot) {
        this.bot = bot;
        this.msg = new ApiRequestBuilder().action("query").formatXml().param("list", "random").param("rnnamespace", "0").param("rnlimit", "1").buildGet();
    }

    public String getTitle() {
        if (!this.title.isPresent()) {
            this.title = Optional.fromNullable((Object)this.bot.getPerformedAction(this).getTitle());
        }
        return (String)this.title.get();
    }

    @Override
    public String processAllReturningText(String xml) {
        String xpathResult = XmlConverter.evaluateXpath(xml, "/api/query/random/page/@title");
        this.title = Optionals.absentIfEmpty(xpathResult);
        log.debug("Title: {}", this.title);
        return "";
    }

    @Override
    public HttpAction getNextMessage() {
        return this.msg;
    }
}

