/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.queries;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jwbf.core.actions.RequestBuilder;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.queries.BaseQuery;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecentchangeTitles
extends BaseQuery<String> {
    private static final Logger log = LoggerFactory.getLogger(RecentchangeTitles.class);
    private static final int LIMIT = 50;
    private final MediaWikiBot bot;
    private final int[] namespaces;

    private HttpAction generateRequest(int[] namespace, String rcstart) {
        RequestBuilder requestBuilder = new ApiRequestBuilder().action("query").formatXml().param("list", "recentchanges").param("rclimit", 50);
        if (namespace != null) {
            requestBuilder.param("rcnamespace", MediaWiki.urlEncode(MWAction.createNsString(namespace)));
        }
        if (rcstart.length() > 0) {
            requestBuilder.param("rcstart", rcstart);
        }
        return requestBuilder.buildGet();
    }

    private HttpAction generateRequest(int[] namespace) {
        return this.generateRequest(namespace, "");
    }

    public RecentchangeTitles(MediaWikiBot bot, int ... ns) {
        super(bot);
        this.namespaces = ns;
        this.bot = bot;
    }

    public RecentchangeTitles(MediaWikiBot bot) {
        this(bot, MediaWiki.NS_ALL);
    }

    @Override
    protected ImmutableList<String> parseElements(String s) {
        XmlElement root = XmlConverter.getRootElement(s);
        ArrayList titleCollection = Lists.newArrayList();
        this.findContent(root, titleCollection);
        return ImmutableList.copyOf((Collection)titleCollection);
    }

    private void findContent(XmlElement root, List<String> titleCollection) {
        for (XmlElement xmlElement : root.getChildren()) {
            if (xmlElement.getQualifiedName().equalsIgnoreCase("rc")) {
                titleCollection.add(MediaWiki.htmlUnescape(xmlElement.getAttributeValue("title")));
                this.setNextPageInfo(xmlElement.getAttributeValue("timestamp"));
                continue;
            }
            this.findContent(xmlElement, titleCollection);
        }
    }

    @Override
    protected HttpAction prepareNextRequest() {
        if (this.hasNextPageInfo()) {
            return this.generateRequest(this.namespaces, this.getNextPageInfo());
        }
        return this.generateRequest(this.namespaces);
    }

    @Override
    protected Iterator<String> copy() {
        return new RecentchangeTitles(this.bot, this.namespaces);
    }

    @Override
    protected Optional<String> parseHasMore(String s) {
        return Optional.absent();
    }
}

