/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.queries;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import net.sourceforge.jwbf.core.actions.RequestBuilder;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.mapper.XmlConverter;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.queries.BaseQuery;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateUserTitles
extends BaseQuery<String> {
    private static final Logger log = LoggerFactory.getLogger(TemplateUserTitles.class);
    private final MediaWikiBot bot;
    private final String templateName;
    private final ImmutableList<Integer> namespaces;
    private final int limit;

    public TemplateUserTitles(MediaWikiBot bot, String templateName, int ... namespaces) {
        this(bot, 50, templateName, MWAction.nullSafeCopyOf(namespaces));
    }

    TemplateUserTitles(MediaWikiBot bot, int limit, String templateName, ImmutableList<Integer> namespaces) {
        super(bot);
        this.bot = bot;
        this.templateName = templateName;
        this.namespaces = namespaces;
        this.limit = limit;
    }

    @Override
    protected Optional<String> parseHasMore(String xml) {
        return this.parseXmlHasMore(xml, "embeddedin", "eicontinue", "eicontinue");
    }

    @Override
    protected ImmutableList<String> parseElements(String xml) {
        Optional<XmlElement> children = XmlConverter.getChildOpt(xml, "query", "embeddedin");
        ImmutableList.Builder titleCollection = ImmutableList.builder();
        if (children.isPresent()) {
            for (XmlElement e : ((XmlElement)children.get()).getChildren("ei")) {
                titleCollection.add((Object)e.getAttributeValue("title"));
            }
        }
        return titleCollection.build();
    }

    @Override
    protected HttpAction prepareNextRequest() {
        Optional<String> eicontinue;
        RequestBuilder requestBuilder = new ApiRequestBuilder().action("query").paramNewContinue(this.bot.getVersion()).formatXml().param("list", "embeddedin").param("eilimit", this.limit).param("eititle", MediaWiki.urlEncode(this.templateName));
        String namespacesValue = MWAction.createNsString(this.namespaces);
        if (!Strings.isNullOrEmpty((String)namespacesValue)) {
            requestBuilder.param("einamespace", MediaWiki.urlEncode(namespacesValue));
        }
        if ((eicontinue = this.nextPageInfoOpt()).isPresent()) {
            requestBuilder.param("eicontinue", MediaWiki.urlEncode((String)eicontinue.get()));
        }
        return requestBuilder.buildGet();
    }

    @Override
    protected Iterator<String> copy() {
        return new TemplateUserTitles(this.bot, this.limit, this.templateName, this.namespaces);
    }
}

