/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.bots;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import net.sourceforge.jwbf.core.actions.ContentProcessable;
import net.sourceforge.jwbf.core.actions.HttpActionClient;
import net.sourceforge.jwbf.core.actions.util.ActionException;
import net.sourceforge.jwbf.core.bots.HttpBot;
import net.sourceforge.jwbf.core.bots.WikiBot;
import net.sourceforge.jwbf.core.contentRep.Article;
import net.sourceforge.jwbf.core.contentRep.SimpleArticle;
import net.sourceforge.jwbf.core.contentRep.Userinfo;
import net.sourceforge.jwbf.core.internal.Checked;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.editing.GetRevision;
import net.sourceforge.jwbf.mediawiki.actions.editing.PostDelete;
import net.sourceforge.jwbf.mediawiki.actions.editing.PostModifyContent;
import net.sourceforge.jwbf.mediawiki.actions.login.PostLogin;
import net.sourceforge.jwbf.mediawiki.actions.meta.GetUserinfo;
import net.sourceforge.jwbf.mediawiki.actions.meta.GetVersion;
import net.sourceforge.jwbf.mediawiki.actions.meta.Siteinfo;
import net.sourceforge.jwbf.mediawiki.contentRep.LoginData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaWikiBot
implements WikiBot {
    private static final Logger log = LoggerFactory.getLogger(MediaWikiBot.class);
    private LoginData login = null;
    private MediaWiki.Version version = null;
    private Userinfo ui = null;
    private boolean loginChangeUserInfo = false;
    private boolean loginChangeVersion = false;
    @Inject
    private HttpBot bot;
    private HttpActionClient client;
    private static final int DEFAULT_READ_PROPERTIES = 126;

    @VisibleForTesting
    public static char[] invalidLabelChars() {
        return "[]{}<>|".toCharArray();
    }

    public MediaWikiBot() {
    }

    public MediaWikiBot(URL u) {
        this(HttpActionClient.of(u));
    }

    public MediaWikiBot(HttpActionClient client) {
        this.client = client;
        this.bot = new HttpBot(client);
    }

    public MediaWikiBot(String url) {
        if (!url.endsWith(".php") && !url.endsWith("/")) {
            throw new IllegalArgumentException("(" + url + ") url must end with slash or .php");
        }
        this.client = HttpActionClient.of(url);
        this.bot = new HttpBot(this.client);
    }

    public MediaWikiBot(URL url, boolean testHostReachable) {
        if (testHostReachable) {
            HttpBot.getPage(url.toString());
        }
        this.bot = new HttpBot(url);
    }

    public void login(String username, String passwd, String domain) {
        this.login = this.getPerformedAction(new PostLogin(username, passwd, domain)).getLoginData();
        this.loginChangeUserInfo = true;
        if (this.getVersion() == MediaWiki.Version.UNKNOWN) {
            this.loginChangeVersion = true;
        }
    }

    @Override
    public void login(String username, String passwd) {
        this.login(username, passwd, null);
    }

    public synchronized Article getArticle(String name, int properties) {
        return new Article((WikiBot)this, this.readData(name, properties));
    }

    @Override
    public synchronized SimpleArticle readData(String name, int properties) {
        return this.getPerformedAction(new GetRevision(this.getVersion(), name, properties)).getArticle();
    }

    @Override
    public SimpleArticle readData(String name) {
        return this.readData(name, 126);
    }

    public synchronized Article getArticle(String name) {
        return this.getArticle(name, 126);
    }

    @Override
    public synchronized void writeContent(SimpleArticle simpleArticle) {
        if (!this.isLoggedIn()) {
            throw new ActionException("Please login first");
        }
        SimpleArticle nonNullArticle = Checked.nonNull(simpleArticle, "content");
        MediaWikiBot.checkTitle(nonNullArticle.getTitle());
        this.getPerformedAction(new PostModifyContent(this, simpleArticle));
        if (nonNullArticle.getText().trim().length() < 1) {
            throw new RuntimeException("Content is empty, still written");
        }
    }

    static Optional<String> checkTitle(String title) {
        for (char invChar : MediaWikiBot.invalidLabelChars()) {
            if (!title.contains(invChar + "")) continue;
            throw new ActionException("Invalid character \"" + invChar + "\" in label \"" + title + "\"");
        }
        return Optional.of((Object)title);
    }

    public boolean isLoggedIn() {
        return this.login != null && this.login.isLoggedIn();
    }

    @Override
    public Userinfo getUserinfo() {
        if (this.ui == null || this.loginChangeUserInfo) {
            this.ui = this.getPerformedAction(GetUserinfo.class);
            this.loginChangeUserInfo = false;
        }
        return this.ui;
    }

    @Override
    public void delete(String title) {
        this.delete(title, null);
    }

    public void delete(String title, String reason) {
        this.getPerformedAction(new PostDelete(this.getUserinfo(), title, reason));
    }

    @Deprecated
    synchronized String performAction(ContentProcessable a) {
        if (a.isSelfExecuter()) {
            throw new ActionException("this is a selfexcecuting action, please do not perform this action manually");
        }
        return this.bot().performAction(a);
    }

    public synchronized <T extends ContentProcessable> T getPerformedAction(T answer) {
        this.performAction(answer);
        return answer;
    }

    public synchronized <T extends ContentProcessable> T getPerformedAction(Class<T> clazz) {
        try {
            ContentProcessable answer = (ContentProcessable)clazz.newInstance();
            return (T)this.getPerformedAction(answer);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    @VisibleForTesting
    HttpBot bot() {
        if (this.bot == null) {
            throw new IllegalStateException("please use another constructor or inject " + HttpBot.class.getCanonicalName());
        }
        return this.bot;
    }

    @Nonnull
    public MediaWiki.Version getVersion() {
        if (this.version == null || this.loginChangeVersion) {
            GetVersion gs = this.getPerformedAction(GetVersion.class);
            this.version = gs.getVersion();
            this.loginChangeVersion = false;
            log.debug("Version is: {}", (Object)this.version.name());
        }
        return this.version;
    }

    @Nonnull
    public Siteinfo getSiteinfo() {
        return this.getPerformedAction(Siteinfo.class);
    }

    @Override
    public final String getWikiType() {
        return MediaWiki.class.getSimpleName() + " " + (Object)((Object)this.getVersion());
    }
}

