/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.contentRep;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.sourceforge.jwbf.core.internal.Checked;
import net.sourceforge.jwbf.core.internal.NonnullFunction;

public class CategoryItem {
    private final String title;
    private final int namespace;
    private final int pageid;

    public static NonnullFunction<CategoryItem, String> toTitleStringFunction() {
        return new NonnullFunction<CategoryItem, String>(){

            @Override
            @Nonnull
            public String applyNonnull(@Nonnull CategoryItem input) {
                return input.getTitle();
            }
        };
    }

    public CategoryItem(String title, int namespace, int pageid) {
        this.title = Checked.nonNull(title, "title");
        this.namespace = namespace;
        this.pageid = pageid;
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("title", (Object)this.title).add("namespace", this.namespace).add("pageid", this.pageid).toString();
    }

    public String getTitle() {
        return this.title;
    }

    public int getNamespace() {
        return this.namespace;
    }

    public int getPageid() {
        return this.pageid;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CategoryItem) {
            CategoryItem that = (CategoryItem)obj;
            return Objects.equals(that.getTitle(), this.getTitle()) && Objects.equals(that.getPageid(), this.getPageid()) && Objects.equals(that.getNamespace(), this.getNamespace());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.title, this.pageid, this.namespace);
    }
}

