/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.contentRep;

import java.io.File;
import java.util.Objects;
import net.sourceforge.jwbf.core.contentRep.SimpleArticle;

public class SimpleFile
extends SimpleArticle {
    private final File file;

    public SimpleFile(String label, String file) {
        this(label, new File(file));
    }

    public SimpleFile(String label, File file) {
        this.setText("");
        this.setTitle(label);
        this.file = file;
    }

    public SimpleFile(File file) {
        this(file.getName(), file);
    }

    public SimpleFile(String filename) {
        this(new File(filename));
    }

    public File getFile() {
        return this.file;
    }

    public boolean isFile() {
        return this.getFile().isFile();
    }

    public boolean canRead() {
        return this.getFile().canRead();
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.file, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SimpleFile) {
            SimpleFile that = (SimpleFile)obj;
            return super.equals(that) && Objects.equals(this.file, that.file);
        }
        return false;
    }
}

