/*
 * Decompiled with CFR 0.152.
 */
package net.openai.util.fsm;

import java.io.Serializable;
import java.util.Vector;
import net.openai.util.fsm.Condition;
import net.openai.util.fsm.event.StateEvent;
import net.openai.util.fsm.event.StateListener;

public abstract class State
implements Serializable {
    private static int stateNumber = 0;
    private Vector conditions = new Vector();
    private String name = State.getDefaultName();
    private boolean startState = false;
    private boolean endState = false;
    private Vector listeners = new Vector();

    private static synchronized String getDefaultName() {
        return "<Unnamed State " + stateNumber++ + ">";
    }

    public final void setName(String name) {
        if (name == null) {
            throw new NullPointerException("The state name cannot be null!");
        }
        this.name = new String(name);
    }

    public final String getName() {
        return new String(this.name);
    }

    final void setStartStateFlag(boolean startState) {
        if (startState == this.startState) {
            return;
        }
        this.startState = startState;
        this.fireStateEvent(4);
    }

    public final boolean getStartStateFlag() {
        return this.startState;
    }

    public final void setEndStateFlag(boolean endState) {
        if (endState == this.endState) {
            return;
        }
        this.endState = endState;
        this.fireStateEvent(5);
    }

    public final boolean getEndStateFlag() {
        return this.endState;
    }

    public final void addStateListener(StateListener listener) {
        if (listener == null) {
            throw new NullPointerException("Cannot add null listener.");
        }
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(listener)) {
                this.listeners.addElement(listener);
            }
        }
    }

    public final void removeStateListener(StateListener listener) {
        if (listener == null) {
            return;
        }
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(listener);
        }
    }

    private void fireStateEvent(int type) {
        Vector toFireTo = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            toFireTo = (Vector)this.listeners.clone();
        }
        int numListeners = toFireTo.size();
        int i = 0;
        while (i < numListeners) {
            ((StateListener)toFireTo.elementAt(i)).handleStateEvent(new StateEvent(this, type));
            ++i;
        }
    }

    public final void addTransition(Condition condition) {
        if (condition == null) {
            throw new NullPointerException("Cannot add null Condition");
        }
        Vector vector = this.conditions;
        synchronized (vector) {
            if (this.conditions.contains(condition)) {
                this.conditions.removeElement(condition);
            }
            this.conditions.addElement(condition);
        }
        condition.addSourceState(this);
    }

    public final void addTransition(Condition condition, State targetState) {
        this.addTransition(condition);
        condition.setTargetState(targetState);
    }

    public final void removeTransition(Condition condition) {
        if (condition == null) {
            return;
        }
        condition.removeSourceState(this);
        Vector vector = this.conditions;
        synchronized (vector) {
            this.conditions.removeElement(condition);
        }
    }

    public final Vector getTransitions() {
        Vector returnValue = null;
        Vector vector = this.conditions;
        synchronized (vector) {
            if (!this.conditions.isEmpty()) {
                returnValue = (Vector)this.conditions.clone();
            }
        }
        return returnValue;
    }

    final State input(Object condition) {
        if (condition == null) {
            throw new NullPointerException("Null input condition");
        }
        Vector toCheck = this.getTransitions();
        if (toCheck == null) {
            return null;
        }
        int numConditions = toCheck.size();
        int i = 0;
        while (i < numConditions) {
            Condition cond = (Condition)toCheck.elementAt(i);
            if (cond.satisfiedBy(condition)) {
                return cond.getTargetState();
            }
            ++i;
        }
        return null;
    }

    void enterState(Object input) {
        this.fireStateEvent(0);
        this.enter(input);
        this.fireStateEvent(1);
    }

    Object exitState() {
        this.fireStateEvent(2);
        Object returnValue = this.exit();
        this.fireStateEvent(3);
        return returnValue;
    }

    public abstract void enter(Object var1);

    public abstract Object exit();
}

