/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcontrols.configuration;

import info.magnolia.cms.i18n.Messages;
import info.magnolia.context.MgnlContext;
import info.magnolia.module.ModuleRegistry;
import java.util.ArrayList;
import java.util.Map;
import net.sourceforge.openutils.mgnlcontrols.configuration.AbstractGridColumnType;
import org.apache.commons.lang.StringUtils;

public class ComboGridColumnType
extends AbstractGridColumnType {
    @Override
    public String getHeadSnippet() {
        StringBuilder result = new StringBuilder(super.getHeadSnippet());
        result.append("<script type=\"text/javascript\" src=\"");
        result.append(MgnlContext.getContextPath());
        result.append("/.resources/controls/" + ModuleRegistry.Factory.getInstance().getDefinition("controls").getVersion() + "/js/PipeComboBox.js\"></script>");
        result.append("<script type=\"text/javascript\">");
        result.append("var PatchedComboBox = Ext.extend(Ext.form.ComboBox, {");
        result.append("  setValue: function(v) {");
        result.append("    this.store.clearFilter();");
        result.append("    PatchedComboBox.superclass.setValue.call(this, v);");
        result.append("  }");
        result.append("});\n");
        result.append("</script>");
        return result.toString();
    }

    @Override
    public String drawSupportHtml(String propertyName, int colIndex, Map colmap, Messages msgs) {
        StringBuilder sb = new StringBuilder();
        sb.append("<select id=\"combo-" + propertyName + "\" name=\"combo-" + propertyName + "\" style=\"display: none;\">");
        Map optionMap = (Map)colmap.get("options");
        for (Object optionValue : optionMap.values()) {
            Map option = (Map)optionValue;
            sb.append("<option value=\"" + option.get("value") + "\">" + option.get("label") + "</option>");
        }
        sb.append("</select>");
        return new String(sb);
    }

    @Override
    protected void addColumnData(Map<String, String> column, String propertyName, int colIndex, Map colMap, Messages msgs) {
        ArrayList<String> options = new ArrayList<String>();
        options.add("typeAhead: true");
        options.add("triggerAction: 'all'");
        options.add("transform: 'combo-" + propertyName + "'");
        options.add("lazyRender: true");
        options.add("listClass: 'x-combo-list-small'");
        if ("true".equals(String.valueOf(colMap.get("showLabel")))) {
            column.put("editor", "(function() { window.gridComboColumnTypeTmp = new " + ("true".equals(String.valueOf(colMap.get("pipe"))) ? "PipeComboBox" : "PatchedComboBox") + "({" + StringUtils.join(options, (String)",") + "}); return new Ed(gridComboColumnTypeTmp); })()");
            column.put("renderer", "(function(combo){    return function(value){        var record = combo.findRecord(combo.valueField, value);        return record ? record.get(combo.displayField) : combo.valueNotFoundText;    }})(window.gridComboColumnTypeTmp)");
        } else {
            column.put("editor", "new Ed(new " + ("true".equals(String.valueOf(colMap.get("pipe"))) ? "PipeComboBox" : "PatchedComboBox") + "({" + StringUtils.join(options, (String)",") + "}))");
        }
    }
}

