/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcontrols.configuration;

import info.magnolia.cms.beans.runtime.Document;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.core.NodeData;
import info.magnolia.cms.core.Path;
import info.magnolia.cms.i18n.Messages;
import info.magnolia.cms.security.AccessDeniedException;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.context.MgnlContext;
import info.magnolia.module.ModuleRegistry;
import info.magnolia.module.admininterface.SaveHandlerImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import javax.jcr.RepositoryException;
import net.sourceforge.openutils.mgnlcontrols.configuration.AbstractGridColumnType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.safehaus.uuid.UUIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditCodeGridColumnType
extends AbstractGridColumnType {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public static String escapeEditCodeGridColumnValue(String value) {
        return StringEscapeUtils.escapeJava((String)StringEscapeUtils.escapeXml((String)value));
    }

    public static String unescapeEditCodeGridColumnValue(String value) {
        return StringEscapeUtils.unescapeXml((String)StringEscapeUtils.unescapeJava((String)value));
    }

    @Override
    public String getHeadSnippet() {
        return "<script type=\"text/javascript\" src=\"" + MgnlContext.getContextPath() + "/.resources/controls/" + ModuleRegistry.Factory.getInstance().getDefinition("controls").getVersion() + "/js/EditCodeField.js\"></script>";
    }

    @Override
    public void processColumnOnLoad(String[] column, Content colConfig, String propertyName, Content storageNode) {
        if (NodeDataUtil.getBoolean((Content)colConfig, (String)"binary", (boolean)false)) {
            HierarchyManager hm = storageNode.getHierarchyManager();
            for (int index = 0; index < column.length; ++index) {
                String value = "";
                String link = StringUtils.trim((String)column[index]);
                if (StringUtils.isNotBlank((String)link)) {
                    NodeData nodeData = null;
                    try {
                        nodeData = hm.getNodeData(storageNode.getHandle() + "/" + StringUtils.substringBeforeLast((String)link, (String)"/"));
                    }
                    catch (RepositoryException e) {
                        this.log.warn(e.getMessage(), (Throwable)e);
                    }
                    if (nodeData != null) {
                        try {
                            value = EditCodeGridColumnType.escapeEditCodeGridColumnValue(StringUtils.join((Collection)IOUtils.readLines((InputStream)nodeData.getStream(), (String)"UTF-8"), (char)'\n'));
                        }
                        catch (Exception e) {
                            this.log.warn(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                column[index] = value;
            }
        }
    }

    @Override
    public void processColumnOnSave(String[] column, Content colConfig, String propertyName, Content parentNode) throws RepositoryException, AccessDeniedException {
        if (NodeDataUtil.getBoolean((Content)colConfig, (String)"binary", (boolean)false)) {
            String filename = NodeDataUtil.getString((Content)colConfig, (String)"binaryFilename", (String)"file.txt");
            String type = NodeDataUtil.getString((Content)colConfig, (String)"binaryType", (String)"text/plain");
            HierarchyManager hm = parentNode.getHierarchyManager();
            Content filesNode = ContentUtil.getOrCreateContent((Content)parentNode, (String)(propertyName + "_" + colConfig.getName() + "_files"), (ItemType)ItemType.CONTENTNODE);
            for (NodeData fileNodeData : filesNode.getNodeDataCollection()) {
                fileNodeData.delete();
            }
            String uuid = UUIDGenerator.getInstance().generateTimeBasedUUID().toString();
            File tmpDir = new File(Path.getTempDirectoryPath() + "/fckeditor/" + uuid);
            for (int index = 0; index < column.length; ++index) {
                String link;
                if (StringUtils.isEmpty((String)column[index])) continue;
                File tmpFile = new File(tmpDir, filename);
                try {
                    FileUtils.writeStringToFile((File)tmpFile, (String)EditCodeGridColumnType.unescapeEditCodeGridColumnValue(column[index]), (String)"UTF-8");
                }
                catch (IOException e) {
                    this.log.error("can't write to tmp file [" + tmpFile + "]");
                }
                Document doc = new Document(tmpFile, type);
                String fileNodeName = Path.getUniqueLabel((HierarchyManager)hm, (String)filesNode.getHandle(), (String)String.valueOf(System.currentTimeMillis()));
                SaveHandlerImpl.saveDocument((Content)filesNode, (Document)doc, (String)fileNodeName, (String)"", (String)"");
                column[index] = link = filesNode.getName() + "/" + fileNodeName + "/" + doc.getFileNameWithExtension();
                doc.delete();
            }
            try {
                FileUtils.deleteDirectory((File)new File(Path.getTempDirectory() + "/fckeditor/" + uuid));
            }
            catch (IOException e) {
                this.log.error("can't delete tmp file [" + Path.getTempDirectory() + "/fckeditor/" + uuid + "]");
            }
        }
    }

    @Override
    protected void addColumnData(Map<String, String> column, String propertyName, int colIndex, Map colMap, Messages msgs) {
        column.put("editor", "new Ed(new EditCodeField())");
    }
}

