/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcontrols.configuration;

import info.magnolia.cms.beans.runtime.Document;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.core.NodeData;
import info.magnolia.cms.core.Path;
import info.magnolia.cms.gui.fckeditor.FCKEditorTmpFiles;
import info.magnolia.cms.i18n.Messages;
import info.magnolia.cms.security.AccessDeniedException;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.context.MgnlContext;
import info.magnolia.module.ModuleRegistry;
import info.magnolia.module.admininterface.SaveHandlerImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.jcr.RepositoryException;
import net.sourceforge.openutils.mgnlcontrols.configuration.AbstractGridColumnType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileGridColumnType
extends AbstractGridColumnType {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public String getHeadSnippet() {
        return "<script type=\"text/javascript\" src=\"" + MgnlContext.getContextPath() + "/.resources/controls/" + ModuleRegistry.Factory.getInstance().getDefinition("controls").getVersion() + "/js/FileField.js\"></script>";
    }

    @Override
    protected void addColumnData(Map<String, String> column, String propertyName, int colIndex, Map colMap, Messages msgs) {
        column.put("editor", "new Ed(new FileField({}))");
        column.put("renderer", "function(v, p, record){ return v ? v.replace(/^.*\\//, '') : v;}");
    }

    @Override
    public void processColumnOnSave(String[] column, Content colConfig, String propertyName, Content parentNode) throws RepositoryException, AccessDeniedException {
        String ctx = MgnlContext.getContextPath();
        HierarchyManager hm = parentNode.getHierarchyManager();
        Content filesNode = ContentUtil.getOrCreateContent((Content)parentNode, (String)(propertyName + "_files"), (ItemType)ItemType.CONTENTNODE);
        String tmpPath = "/tmp/fckeditor/";
        ArrayList<String> usedFiles = new ArrayList<String>();
        for (int index = 0; index < column.length; ++index) {
            String link;
            if (StringUtils.isEmpty((String)column[index])) continue;
            if (column[index].startsWith(ctx) && StringUtils.startsWith((String)(link = StringUtils.removeStart((String)column[index], (String)ctx)), (String)tmpPath)) {
                String uuid = StringUtils.substringBetween((String)link, (String)tmpPath, (String)"/");
                Document doc = FCKEditorTmpFiles.getDocument((String)uuid);
                String fileNodeName = Path.getUniqueLabel((HierarchyManager)hm, (String)filesNode.getHandle(), (String)"file");
                SaveHandlerImpl.saveDocument((Content)filesNode, (Document)doc, (String)fileNodeName, (String)"", (String)"");
                column[index] = link = filesNode.getHandle() + "/" + fileNodeName + "/" + doc.getFileNameWithExtension();
                doc.delete();
                try {
                    FileUtils.deleteDirectory((File)new File(Path.getTempDirectory() + "/fckeditor/" + uuid));
                }
                catch (IOException e) {
                    this.log.error("can't delete tmp file [" + Path.getTempDirectory() + "/fckeditor/" + uuid + "]");
                }
            }
            if (!column[index].startsWith(filesNode.getHandle())) continue;
            String fileNodeName = StringUtils.removeStart((String)column[index], (String)(filesNode.getHandle() + "/"));
            fileNodeName = StringUtils.substringBefore((String)fileNodeName, (String)"/");
            usedFiles.add(fileNodeName);
        }
        for (NodeData fileNodeData : filesNode.getNodeDataCollection()) {
            if (usedFiles.contains(fileNodeData.getName())) continue;
            fileNodeData.delete();
        }
    }
}

