/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcontrols.configuration;

import info.magnolia.cms.beans.config.ObservedManager;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.content2bean.Content2BeanUtil;
import info.magnolia.objectfactory.Components;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;
import net.sourceforge.openutils.mgnlcontrols.configuration.GridColumnType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GridColumnTypeManager
extends ObservedManager {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Map<String, GridColumnType> columnTypes = new HashMap<String, GridColumnType>();

    public static GridColumnTypeManager getInstance() {
        return (GridColumnTypeManager)((Object)Components.getSingleton(GridColumnTypeManager.class));
    }

    public Map<String, GridColumnType> getColumnTypes() {
        return this.columnTypes;
    }

    protected void onClear() {
        this.columnTypes.clear();
    }

    protected void onRegister(Content node) {
        for (Content columnTypeNode : ContentUtil.getAllChildren((Content)node)) {
            if (!NodeDataUtil.getBoolean((Content)columnTypeNode, (String)"enabled", (boolean)true)) continue;
            try {
                GridColumnType columnType = (GridColumnType)Content2BeanUtil.toBean((Content)columnTypeNode);
                this.columnTypes.put(columnTypeNode.getName(), columnType);
            }
            catch (Throwable e) {
                this.log.error("Error getting column type {}", (Object)columnTypeNode.getHandle(), (Object)e);
            }
        }
    }
}

