/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcontrols.configuration;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.i18n.Messages;
import info.magnolia.cms.security.AccessDeniedException;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.context.MgnlContext;
import info.magnolia.module.ModuleRegistry;
import java.util.ArrayList;
import java.util.Map;
import javax.jcr.RepositoryException;
import net.sourceforge.openutils.mgnlcontrols.configuration.AbstractGridColumnType;
import org.apache.commons.lang.StringUtils;

public class UUIDLinkGridColumnType
extends AbstractGridColumnType {
    @Override
    public String getHeadSnippet() {
        return "<script type=\"text/javascript\" src=\"" + MgnlContext.getContextPath() + "/.resources/controls/" + ModuleRegistry.Factory.getInstance().getDefinition("controls").getVersion() + "/js/UUIDLinkField.js\"></script>";
    }

    @Override
    protected void addColumnData(Map<String, String> column, String propertyName, int colIndex, Map colMap, Messages msgs) {
        ArrayList<String> options = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)((String)colMap.get("tree")))) {
            options.add("repository: '" + colMap.get("tree") + "'");
        } else if (!StringUtils.isEmpty((String)((String)colMap.get("repository")))) {
            options.add("repository: '" + colMap.get("repository") + "'");
        }
        if (!StringUtils.isEmpty((String)((String)colMap.get("extension")))) {
            options.add("extension: '" + colMap.get("extension") + "'");
        }
        column.put("editor", "new Ed(new UUIDLinkField({" + StringUtils.join(options, (String)",") + "}))");
    }

    @Override
    public void processColumnOnLoad(String[] column, Content colConfig, String propertyName, Content storageNode) {
        String repository = StringUtils.defaultIfEmpty((String)NodeDataUtil.getString((Content)colConfig, (String)"repository"), (String)"website");
        for (int index = 0; index < column.length; ++index) {
            Content node;
            String nodeuuid = StringUtils.trim((String)column[index]);
            if (!StringUtils.isNotBlank((String)nodeuuid) || (node = ContentUtil.getContentByUUID((String)repository, (String)nodeuuid)) == null) continue;
            column[index] = node.getHandle();
        }
    }

    @Override
    public void processColumnOnSave(String[] column, Content colConfig, String propertyName, Content parentNode) throws RepositoryException, AccessDeniedException {
        String repository = StringUtils.defaultIfEmpty((String)NodeDataUtil.getString((Content)colConfig, (String)"repository"), (String)"website");
        for (int index = 0; index < column.length; ++index) {
            Content node;
            if (StringUtils.isEmpty((String)column[index]) || (node = ContentUtil.getContent((String)repository, (String)column[index])) == null) continue;
            column[index] = node.getUUID();
        }
    }
}

