/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcontrols.dialog;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.gui.control.Button;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.cms.util.NodeDataUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogButtonSet
extends info.magnolia.cms.gui.dialog.DialogButtonSet {
    private static Logger log = LoggerFactory.getLogger(DialogButtonSet.class);
    private OptionsProvider optionsProvider = new OptionsProvider.DefaultImpl();
    private boolean initHack;

    public void init(HttpServletRequest request, HttpServletResponse response, Content websiteNode, Content configNode) throws RepositoryException {
        String optionsProviderClass = NodeDataUtil.getString((Content)configNode, (String)"optionsProvider");
        try {
            this.optionsProvider = (OptionsProvider)Class.forName(optionsProviderClass).newInstance();
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        this.initHack = true;
        super.init(request, response, websiteNode, configNode);
        this.initHack = false;
    }

    public String getConfigValue(String key, String nullValue) {
        String val = super.getConfigValue(key, nullValue);
        if (this.initHack && StringUtils.equals((String)key, (String)"selectType") && StringUtils.equals((String)val, (String)nullValue)) {
            val = StringUtils.removeStart((String)val, (String)"controls-");
        }
        return val;
    }

    public void setOptions(Content configNode, boolean setDefaultSelected) {
        ArrayList<Button> options;
        block5: {
            options = new ArrayList<Button>();
            try {
                Iterator<Option> it = this.optionsProvider.getOptions(this, configNode);
                while (it.hasNext()) {
                    Option o = it.next();
                    Button button = new Button(this.getName(), o.getValue());
                    button.setLabel(o.getLabel());
                    if (StringUtils.isNotEmpty((String)o.getIconSrc())) {
                        button.setIconSrc(o.getIconSrc());
                    }
                    if (setDefaultSelected && o.isSelected()) {
                        button.setState(3);
                    }
                    options.add(button);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("Exception caught: " + e.getMessage(), (Throwable)e);
            }
        }
        this.setOptions(options);
    }

    public static interface OptionsProvider {
        public Iterator<Option> getOptions(DialogButtonSet var1, Content var2) throws Exception;

        public static class DefaultImpl
        implements OptionsProvider {
            @Override
            public Iterator<Option> getOptions(final DialogButtonSet control, Content configNode) throws Exception {
                Content optionsNode = null;
                if (configNode.hasContent("options")) {
                    optionsNode = configNode.getContent("options");
                } else {
                    String repository = control.getConfigValue("repository", "website");
                    String path = control.getConfigValue("path");
                    if (StringUtils.isNotEmpty((String)path)) {
                        optionsNode = ContentUtil.getContent((String)repository, (String)path);
                    }
                }
                if (optionsNode != null) {
                    return Iterators.transform(ContentUtil.getAllChildren((Content)optionsNode).iterator(), (Function)new Function<Content, Option>(){

                        public Option apply(Content input) {
                            return new Option.ContentAdapter(input, control.getConfigValue("valueNodeData", "value"), control.getConfigValue("labelNodeData", "label"));
                        }
                    });
                }
                return new ArrayList().iterator();
            }
        }
    }

    public static interface Option {
        public String getValue();

        public String getLabel();

        public String getIconSrc();

        public boolean isSelected();

        public static class MapAdapter
        implements Option {
            private final Map map;
            private final String valueNodeData;
            private final String labelNodeData;

            public MapAdapter(Map map, String valueNodeData, String labelNodeData) {
                this.map = map;
                this.valueNodeData = valueNodeData;
                this.labelNodeData = labelNodeData;
            }

            @Override
            public String getValue() {
                return ObjectUtils.toString(this.map.get(this.valueNodeData));
            }

            @Override
            public String getLabel() {
                return ObjectUtils.toString(this.map.get(this.labelNodeData));
            }

            @Override
            public String getIconSrc() {
                return ObjectUtils.toString(this.map.get("iconSrc"));
            }

            @Override
            public boolean isSelected() {
                return BooleanUtils.toBoolean((String)ObjectUtils.toString(this.map.get("selected")));
            }
        }

        public static class ContentAdapter
        implements Option {
            private final Content node;
            private final String valueNodeData;
            private final String labelNodeData;

            public ContentAdapter(Content node, String valueNodeData, String labelNodeData) {
                this.node = node;
                this.valueNodeData = valueNodeData;
                this.labelNodeData = labelNodeData;
            }

            @Override
            public String getValue() {
                return NodeDataUtil.getString((Content)this.node, (String)this.valueNodeData);
            }

            @Override
            public String getLabel() {
                return NodeDataUtil.getString((Content)this.node, (String)this.labelNodeData);
            }

            @Override
            public String getIconSrc() {
                return this.node.getNodeData("iconSrc").getString();
            }

            @Override
            public boolean isSelected() {
                return this.node.getNodeData("selected").getBoolean();
            }
        }
    }
}

