/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcontrols.dialog;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.util.NodeDataUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.openutils.mgnlcontrols.configuration.GridColumnType;
import net.sourceforge.openutils.mgnlcontrols.configuration.GridColumnTypeManager;
import net.sourceforge.openutils.mgnlcontrols.dialog.ConfigurableFreemarkerDialog;
import net.sourceforge.openutils.mgnlcontrols.dialog.DialogGridSaveHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class DialogGrid
extends ConfigurableFreemarkerDialog {
    private List<Content> colConfigs = new ArrayList<Content>();

    @Override
    public void init(HttpServletRequest request, HttpServletResponse response, Content websiteNode, Content configNode) throws RepositoryException {
        super.init(request, response, websiteNode, configNode);
        if (StringUtils.isEmpty((String)this.getConfigValue("saveHandler"))) {
            this.setConfig("saveHandler", "net.sourceforge.openutils.mgnlcontrols.dialog.DialogGridSaveHandler");
        }
        if (configNode != null && configNode.hasContent("columns")) {
            this.colConfigs.addAll(configNode.getContent("columns").getChildren(ItemType.CONTENTNODE));
        }
    }

    @Override
    protected String getPath() {
        return "dialogs/grid.ftl";
    }

    @Override
    protected void addToParameters(Map<String, Object> parameters) {
        super.addToParameters(parameters);
        Map<String, GridColumnType> colTypeMap = GridColumnTypeManager.getInstance().getColumnTypes();
        parameters.put("gridColumnTypes", colTypeMap);
        String value = this.getValue();
        if (value != null) {
            int rows = NumberUtils.toInt((String)String.valueOf(this.getConfigValue("rows")), (int)-1);
            if (rows > 0) {
                value = this.adjustRowCount(value, rows);
            }
            List<String[]> columns = DialogGridSaveHandler.valueToColumns(value);
            int colIndex = 0;
            for (String[] column : columns) {
                Content colConfig;
                String colTypeName;
                GridColumnType colType;
                if (colIndex < this.colConfigs.size() && (colType = colTypeMap.get(colTypeName = NodeDataUtil.getString((Content)(colConfig = this.colConfigs.get(colIndex)), (String)"type"))) != null) {
                    colType.processColumnOnLoad(column, colConfig, this.getName(), this.getStorageNode());
                }
                ++colIndex;
            }
            value = DialogGridSaveHandler.columnsToValue(columns);
        }
        parameters.put("gridValue", value);
    }

    protected String adjustRowCount(String value, int count) {
        String row;
        ArrayList<String> rows = new ArrayList<String>(Arrays.asList(StringUtils.splitPreserveAllTokens((String)value, (char)'\n')));
        while (rows.size() < count) {
            rows.add("");
        }
        while (rows.size() > count && StringUtils.isEmpty((String)StringUtils.remove((String)(row = StringUtils.removeEnd((String)((String)rows.get(rows.size() - 1)), (String)"\r")), (char)'\t'))) {
            rows.remove(rows.size() - 1);
        }
        return StringUtils.join(rows, (char)'\n');
    }
}

