/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcontrols.dialog;

import info.magnolia.cms.beans.runtime.MultipartForm;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.security.AccessDeniedException;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.module.admininterface.FieldSaveHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import net.sourceforge.openutils.mgnlcontrols.configuration.GridColumnType;
import net.sourceforge.openutils.mgnlcontrols.configuration.GridColumnTypeManager;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogGridSaveHandler
implements FieldSaveHandler {
    private static Logger log = LoggerFactory.getLogger(DialogGridSaveHandler.class);

    public static List<String[]> valueToColumns(String value) {
        String[] allRows = StringUtils.splitPreserveAllTokens((String)value, (char)'\n');
        ArrayList<String[]> columns = new ArrayList<String[]>();
        int rowIndex = 0;
        for (String row : allRows) {
            row = StringUtils.removeEnd((String)row, (String)"\r");
            int colIndex = 0;
            for (String token : StringUtils.splitPreserveAllTokens((String)row, (char)'\t')) {
                if (columns.size() < colIndex + 1) {
                    columns.add(new String[allRows.length]);
                }
                ((String[])columns.get((int)colIndex))[rowIndex] = token;
                ++colIndex;
            }
            ++rowIndex;
        }
        return columns;
    }

    public static String columnsToValue(List<String[]> columns) {
        int rowCount = 0;
        for (String[] column : columns) {
            rowCount = Math.max(rowCount, column.length);
        }
        StringBuilder sbValue = new StringBuilder();
        StringBuilder sbLine = new StringBuilder();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            int colIndex = 0;
            for (String[] column : columns) {
                if (colIndex > 0) {
                    sbLine.append('\t');
                }
                sbLine.append(StringUtils.defaultString((String)column[rowIndex]));
                ++colIndex;
            }
            if (sbValue.length() > 0) {
                sbValue.append('\n');
            }
            sbValue.append((CharSequence)sbLine);
            sbLine.setLength(0);
        }
        return new String(sbValue);
    }

    public void save(Content parentNode, Content configNode, String name, MultipartForm form, int type, int valueType, int isRichEditValue, int encoding) throws RepositoryException, AccessDeniedException {
        String value = form.getParameter(name);
        ArrayList colConfigs = new ArrayList();
        if (configNode != null && configNode.hasContent("columns")) {
            colConfigs.addAll(configNode.getContent("columns").getChildren(ItemType.CONTENTNODE));
        }
        Map<String, GridColumnType> colTypeMap = GridColumnTypeManager.getInstance().getColumnTypes();
        List<String[]> columns = DialogGridSaveHandler.valueToColumns(value);
        int colIndex = 0;
        for (Content colConfig : colConfigs) {
            String colTypeName = NodeDataUtil.getString((Content)colConfig, (String)"type");
            GridColumnType colType = colTypeMap.get(colTypeName);
            if (colType != null && colIndex < columns.size()) {
                colType.processColumnOnSave(columns.get(colIndex), colConfig, name, parentNode);
            }
            ++colIndex;
        }
        NodeDataUtil.getOrCreateAndSet((Content)parentNode, (String)name, (Object)DialogGridSaveHandler.columnsToValue(columns));
    }
}

