/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcontrols.dialog;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.gui.dialog.DialogControlImpl;
import info.magnolia.cms.gui.dialog.DialogTab;
import info.magnolia.cms.i18n.I18nContentSupportFactory;
import info.magnolia.cms.security.AccessDeniedException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nDialogTab
extends DialogTab {
    private static final String ATTRIBUTE_MOOTOOLS_LOADED = "info.magnolia.cms.gui.dialog.mootools.loaded";
    private static final String ATTRIBUTE_JQUERY_LOADED = "info.magnolia.cms.gui.dialog.jquery.loaded";
    private static final String ATTRIBUTE_I18NTAB_LOADED = "info.magnolia.cms.gui.dialog.i18ntab.loaded";
    private Map<String, String> mapLocales = new LinkedHashMap<String, String>();
    private static Logger log = LoggerFactory.getLogger(I18nDialogTab.class);
    private Set<String> localesToRender;
    private String localeSuffixSeparator;
    private String visibleLocale;
    private String newLocale = "";
    private String jsFramework;

    public void init(HttpServletRequest request, HttpServletResponse response, Content storageNode, Content configNode) throws RepositoryException {
        super.init(request, response, storageNode, configNode);
        this.localeSuffixSeparator = this.getConfigValue("localeSuffixSeparator", "_");
        this.newLocale = request.getParameter("mgnlI18nLocale");
        this.setConfiguredLanguages(configNode);
        if (this.newLocale != null) {
            this.localesToRender = Collections.singleton(this.newLocale);
            this.visibleLocale = this.newLocale;
        } else {
            this.visibleLocale = this.getConfigValue("defaultLocale", this.mapLocales.keySet().iterator().next());
            this.localesToRender = new HashSet<String>();
            Content node = this.getStorageNode();
            for (String locale : this.mapLocales.keySet()) {
                if (!locale.equals(this.visibleLocale) && (node == null || node.getNodeDataCollection('*' + this.localeSuffixSeparator + locale).isEmpty())) continue;
                this.localesToRender.add(locale);
            }
        }
        this.jsFramework = this.getConfigValue("jsFramework", "jquery");
    }

    public void drawHtmlPreSubs(Writer out) throws IOException {
        String jsFrameworkFilename;
        String jsFrameworkAttributeName;
        if (this.newLocale != null) {
            return;
        }
        Locale fallbackLocale = I18nContentSupportFactory.getI18nSupport().getFallbackLocale();
        String fallbackLocaleCode = fallbackLocale.toString();
        if ("jquery".equals(this.jsFramework)) {
            jsFrameworkAttributeName = ATTRIBUTE_JQUERY_LOADED;
            jsFrameworkFilename = "jquery.min.js";
        } else {
            jsFrameworkAttributeName = ATTRIBUTE_MOOTOOLS_LOADED;
            jsFrameworkFilename = "mootools-1.2.4-core-yc.js";
        }
        if (this.getRequest().getAttribute(jsFrameworkAttributeName) == null) {
            out.write("<script type=\"text/javascript\" src=\"" + this.getRequest().getContextPath() + "/.resources/controls/js/" + jsFrameworkFilename + "\"></script>");
            this.getRequest().setAttribute(jsFrameworkAttributeName, (Object)"true");
        }
        if (this.getRequest().getAttribute(ATTRIBUTE_I18NTAB_LOADED) == null) {
            out.write("<script type=\"text/javascript\" src=\"" + this.getRequest().getContextPath() + "/.resources/controls/js/i18ntab-" + this.jsFramework + ".js\"></script>");
            out.write("<script type=\"text/javascript\">");
            out.write("var i18nTabLocales = [");
            boolean firstElement = true;
            for (String locale : this.mapLocales.keySet()) {
                if (!firstElement) {
                    out.write(",");
                }
                out.write("'" + locale + "'");
                firstElement = false;
            }
            out.write("];");
            out.write("</script>");
            this.getRequest().setAttribute(ATTRIBUTE_I18NTAB_LOADED, (Object)"true");
        }
        String id = this.getId();
        out.write("<script type=\"text/javascript\">");
        String options = "{ctx: '" + this.getRequest().getContextPath() + "', path: '" + this.getParent().getConfigValue("path") + "', nodeCollection: '" + this.getParent().getConfigValue("nodeCollection") + "', node: '" + this.getParent().getConfigValue("node") + "', dialog: '" + this.getParent().getName() + "', tab: '" + this.getName() + "'}";
        if ("jquery".equals(this.jsFramework)) {
            out.write("$(document).ready(function() { new $.I18nTab('" + id + "', " + options + "); });");
        } else {
            out.write("window.addEvent('domready', function() { new I18nTab('" + id + "', " + options + "); });");
        }
        out.write("</script>");
        super.drawHtmlPreSubs(out);
        out.write("<tr>");
        out.write("<td class=\"mgnlDialogBoxLabel\">Locale</td>");
        out.write("<td class=\"mgnlDialogBoxInput\">");
        out.write("<select id=\"" + id + "_select\" class=\"mgnlDialogControlSelect\" style=\"width: 50%\">");
        for (String locale : this.mapLocales.keySet()) {
            this.addLocaleOption(out, locale, fallbackLocaleCode);
        }
        out.write("</select>");
        out.write("</td>");
        out.write("</tr>");
        out.write("</table>");
    }

    private void addLocaleOption(Writer out, String locale, String fallbackLocaleCode) throws IOException {
        out.write("<option value=\"");
        out.write(locale);
        out.write("\"");
        if (this.localesToRender.contains(locale) || fallbackLocaleCode.equals(locale) && this.localesToRender.contains("")) {
            out.write(" style=\"background-color: #9DB517 !important; font-weight: bold;\"");
        }
        if (locale.equals(this.visibleLocale)) {
            out.write(" selected=\"selected\"");
        }
        out.write(">");
        out.write(this.mapLocales.get(locale));
        if (StringUtils.isNotBlank((String)locale)) {
            out.write(" (" + locale + ")");
        }
        if (StringUtils.equals((String)locale, (String)fallbackLocaleCode)) {
            out.write(" default");
        }
        out.write("</option>");
    }

    protected void drawSubs(Writer out) throws IOException {
        String id = this.getId();
        List<String> originalSubNames = this.getSubNames();
        for (String locale : this.mapLocales.keySet()) {
            if (!this.localesToRender.contains(locale)) continue;
            this.changeSubNames(originalSubNames, locale);
            for (Object o : this.getSubs()) {
                ((DialogControlImpl)o).setValue(null);
            }
            out.write("<table id=\"" + id + "_table_" + locale + "\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"table-layout:fixed;" + (locale.equals(this.visibleLocale) ? "" : " display: none;") + "\">");
            out.write("<col width=\"200\" /><col />");
            super.drawSubs(out);
            out.write("</table>");
        }
        this.changeSubNames(originalSubNames, null);
    }

    public void drawHtmlPostSubs(Writer out) throws IOException {
        if (this.newLocale != null) {
            return;
        }
        out.write("<div id=\"" + this.getId() + "_append\"></div>");
        out.write("</td></tr></table></div>");
    }

    private List<String> getSubNames() {
        ArrayList<String> names = new ArrayList<String>(this.getSubs().size());
        for (Object o : this.getSubs()) {
            names.add(((DialogControlImpl)o).getName());
        }
        return names;
    }

    private void changeSubNames(List<String> names, String suffix) {
        int i = 0;
        for (Object o : this.getSubs()) {
            DialogControlImpl subControl = (DialogControlImpl)o;
            subControl.setName(names.get(i) + (StringUtils.isBlank((String)suffix) ? "" : this.localeSuffixSeparator + suffix));
            ++i;
        }
    }

    private void setConfiguredLanguages(Content configNode) throws PathNotFoundException, RepositoryException, AccessDeniedException {
        Locale fallbackLocale = I18nContentSupportFactory.getI18nSupport().getFallbackLocale();
        Collection locales = I18nContentSupportFactory.getI18nSupport().getLocales();
        for (Locale locale : locales) {
            String code = locale.toString();
            if (locale.equals(fallbackLocale)) {
                this.mapLocales.put("", locale.getDisplayName());
                continue;
            }
            this.mapLocales.put(code, locale.getDisplayName());
        }
    }
}

