/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.cms.core.Path;
import info.magnolia.cms.security.AccessDeniedException;
import info.magnolia.jcr.util.NodeUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.Task;
import info.magnolia.module.delta.TaskExecutionException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddPermissionTask
extends AbstractRepositoryTask
implements Task {
    private final String role;
    private final String repo;
    private final String path;
    private final long permission;
    private Logger log = LoggerFactory.getLogger(AddPermissionTask.class);

    public AddPermissionTask(String role, String repo, String path, long permission) {
        super("Setup permissions on " + repo + ":" + path + " for " + role, "Setup permissions on " + repo + ":" + path + " for " + role);
        this.role = role;
        this.repo = repo;
        this.path = path;
        this.permission = permission;
    }

    protected void doExecute(InstallContext installContext) throws RepositoryException, TaskExecutionException {
        Session hm = installContext.getJCRSession("userroles");
        Node roleNode = hm.getNode("/" + this.role);
        this.setupAcl(roleNode, this.repo, this.path, this.permission);
    }

    private void setupAcl(Node role, String repository, String path, long newpermissions) throws RepositoryException, AccessDeniedException {
        Node acls = NodeUtil.createPath((Node)role, (String)("acl_" + repository), (String)"mgnl:contentNode");
        Iterable children = NodeUtil.getNodes((Node)acls, (String)"mgnl:contentNode");
        boolean found = false;
        for (Node acl : children) {
            String aclPath;
            if (!acl.hasProperty("path") || !path.equals(aclPath = acl.getProperty("path").getString())) continue;
            found = true;
            long permissions = acl.getProperty("permissions").getLong();
            if (permissions == newpermissions) continue;
            this.setPermission(acl, path, newpermissions);
        }
        if (!found) {
            Node acl = NodeUtil.createPath((Node)acls, (String)Path.getUniqueLabel((Session)acls.getSession(), (String)NodeUtil.getPathIfPossible((Node)acls), (String)"0"), (String)"mgnl:contentNode");
            this.setPermission(acl, path, newpermissions);
        }
    }

    private void setPermission(Node acl, String path, long newpermissions) throws RepositoryException, AccessDeniedException {
        this.log.info("Setting permissions for {} to {}", (Object)(this.repo + ":" + path), (Object)this.role);
        acl.setProperty("path", path);
        acl.setProperty("permissions", newpermissions);
    }
}

