/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.cms.security.AccessDeniedException;
import info.magnolia.jcr.util.NodeUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.Task;
import info.magnolia.module.delta.TaskExecutionException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnonymousUserSetupTask
extends AbstractRepositoryTask
implements Task {
    private boolean allowAccess;
    private Logger log = LoggerFactory.getLogger(AnonymousUserSetupTask.class);

    public AnonymousUserSetupTask(boolean allowAccess) {
        super("Setup anonymous user", allowAccess ? "Adding access to anonymous user" : "Removing access to anonymous user");
        this.allowAccess = allowAccess;
    }

    protected void doExecute(InstallContext installContext) throws RepositoryException, TaskExecutionException {
        Session hm = installContext.getJCRSession("userroles");
        Node role = hm.getNode("/anonymous");
        this.setupAcl(role, "website", "/*", this.allowAccess ? 8L : 0L);
        this.setupAcl(role, "uri", "/*", this.allowAccess ? 63L : 0L);
        this.setupAcl(role, "uri", "/.magnolia*", 0L);
    }

    private void setupAcl(Node role, String repository, String path, long newpermissions) throws RepositoryException, AccessDeniedException {
        Node acls = NodeUtil.createPath((Node)role, (String)("acl_" + repository), (String)"mgnl:contentNode");
        Iterable children = NodeUtil.getNodes((Node)acls, (String)"mgnl:contentNode");
        boolean found = false;
        for (Node acl : children) {
            String aclPath;
            if (!acl.hasProperty("path") || !path.equals(aclPath = acl.getProperty("path").getString())) continue;
            found = true;
            long permissions = acl.getProperty("permissions").getLong();
            if (permissions == newpermissions) continue;
            acl.setProperty("permissions", newpermissions);
        }
        if (!found && StringUtils.equals((String)path, (String)"/*")) {
            this.setupAcl(role, repository, "*", newpermissions);
        }
        if (!found) {
            this.log.warn("Security not configured on anonymous user! No acl for {} found on {}", (Object)path, (Object)repository);
        }
    }
}

