/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.jcr.util.MetaDataUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.TaskExecutionException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResult;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResultItem;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.Criteria;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.JCRCriteriaFactory;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Criterion;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Order;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Restrictions;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCheckMissingTask
extends AbstractRepositoryTask {
    private final String templateOrParagraph;
    private final String nodetype;
    private Logger log = LoggerFactory.getLogger(BaseCheckMissingTask.class);

    public BaseCheckMissingTask(String templateOrParagraph, String nodetype) {
        super("Check " + templateOrParagraph + "s task", "Checking pages configured with missing " + templateOrParagraph + "s");
        this.templateOrParagraph = templateOrParagraph;
        this.nodetype = nodetype;
    }

    protected void doExecute(InstallContext installContext) throws RepositoryException, TaskExecutionException {
        Criteria criteria = JCRCriteriaFactory.createCriteria().setWorkspace("config").add((Criterion)Restrictions.eq((String)"@jcr:primaryType", (Object)"mgnl:contentNode")).addOrder(Order.desc((String)"@jcr:score"));
        if (StringUtils.equals((String)this.templateOrParagraph, (String)"template")) {
            criteria.setBasePath("//modules/*/templates/pages/*");
        } else {
            criteria.setBasePath("//modules/*/templates/components/*");
        }
        AdvancedResult result = criteria.execute();
        ArrayList<String> templ = new ArrayList<String>();
        for (AdvancedResultItem template : result.getItems()) {
            templ.add(template.getName());
        }
        this.checkInvalidPages(installContext, templ);
    }

    private void checkInvalidPages(InstallContext installContext, List<String> templates) throws RepositoryException, InvalidQueryException {
        Criteria criteria = JCRCriteriaFactory.createCriteria().setWorkspace("website").add((Criterion)Restrictions.eq((String)"@jcr:primaryType", (Object)this.nodetype)).add(Restrictions.not((Criterion)Restrictions.in((String)"MetaData/mgnl:template", templates))).addOrder(Order.desc((String)"@jcr:score"));
        this.log.debug("Running query: {}", (Object)criteria.toXpathExpression());
        AdvancedResult result = criteria.execute();
        int count = 0;
        StringBuilder sb = new StringBuilder();
        for (Node page : result.getItems()) {
            String template = MetaDataUtil.getTemplate((Node)page);
            if (!StringUtils.isNotEmpty((String)template)) continue;
            ++count;
            sb.append(page.getPath());
            sb.append("   ");
            sb.append(template);
            sb.append("\n");
        }
        if (count > 0) {
            this.log.error("Found {} pages with invalid " + this.templateOrParagraph + "s:\n{}", (Object)count, (Object)sb.toString());
        }
    }
}

