/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.BootstrapResourcesTask;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapMissingNodesTask
extends BootstrapResourcesTask {
    private String folderName;
    private Logger log = LoggerFactory.getLogger(BootstrapMissingNodesTask.class);

    public BootstrapMissingNodesTask(String folder) {
        super("Loading new content", "Bootstrap of new configuration in " + folder);
        this.folderName = folder;
    }

    protected boolean acceptResource(InstallContext installContext, String name) {
        boolean accept;
        boolean bl = accept = name.startsWith("/mgnl-bootstrap/" + this.folderName + "/") && name.endsWith(".xml");
        if (accept) {
            String handle = StringUtils.substringBetween((String)name, (String)("/mgnl-bootstrap/" + this.folderName + "/"), (String)".xml");
            String workspace = StringUtils.substringBefore((String)handle, (String)".");
            handle = StringUtils.replace((String)StringUtils.substringAfter((String)handle, (String)"."), (String)".", (String)"/");
            try {
                Session session = installContext.getJCRSession(workspace);
                boolean alreadyExisting = session.getRootNode().hasNode(handle);
                if (!alreadyExisting) {
                    this.log.info("Loading {} since no content at {}:{} has been found", new Object[]{name, workspace, "/" + handle});
                }
                return !alreadyExisting;
            }
            catch (RepositoryException e) {
                this.log.debug(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }
}

