/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.jcr.util.PropertyUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.Task;
import info.magnolia.module.delta.TaskExecutionException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeDefaultPasswordTask
extends AbstractRepositoryTask
implements Task {
    private String user;
    private String defaultPassword;
    private String newpassword;
    private Logger log = LoggerFactory.getLogger(ChangeDefaultPasswordTask.class);

    public ChangeDefaultPasswordTask(String user, String defaultPassword, String newpassword) {
        super("Default password check", "Checking default password for " + user);
        this.user = user;
        this.defaultPassword = defaultPassword;
        this.newpassword = newpassword;
    }

    protected void doExecute(InstallContext installContext) throws RepositoryException, TaskExecutionException {
        Session hm = installContext.getJCRSession("users");
        Node role = hm.getNode(this.user);
        String actualPassword = PropertyUtil.getString((Node)role, (String)"pswd");
        if (StringUtils.equals((String)this.defaultPassword, (String)StringUtils.trim((String)actualPassword))) {
            this.log.info("Found default password for {}, setting new password", (Object)this.user);
            role.setProperty("pswd", this.newpassword);
        }
    }
}

