/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.jcr.util.NodeUtil;
import info.magnolia.jcr.util.PropertyUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.TaskExecutionException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;

public class ChangeExistingPropertyTask
extends AbstractRepositoryTask {
    private final String workspaceName;
    private final String nodePath;
    private final String propertyName;
    private final Object newPropertyValue;
    private final Object previousPropertyValue;

    public ChangeExistingPropertyTask(String workspaceName, String nodePath, String propertyName, Object previousPropertyValue, Object newPropertyValue) {
        super("Checking the value of " + nodePath + "/" + propertyName, "Creating property " + nodePath + "/" + propertyName + " and setting its value to " + newPropertyValue + " if the previous value is " + previousPropertyValue);
        this.workspaceName = workspaceName;
        this.nodePath = nodePath;
        this.propertyName = propertyName;
        this.previousPropertyValue = previousPropertyValue;
        this.newPropertyValue = newPropertyValue;
    }

    protected void doExecute(InstallContext ctx) throws RepositoryException, TaskExecutionException {
        Session session = ctx.getJCRSession(this.workspaceName);
        Node node = NodeUtil.createPath((Node)session.getRootNode(), (String)this.nodePath, (String)"mgnl:content");
        if (node.hasProperty(this.propertyName) && !StringUtils.equals((String)node.getProperty(this.propertyName).getString(), (String)this.newPropertyValue.toString())) {
            PropertyUtil.setProperty((Node)node, (String)this.propertyName, (Object)this.newPropertyValue);
        }
    }
}

