/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.jcr.util.NodeUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.TaskExecutionException;
import it.openutils.mgnlutils.util.NodeUtilsExt;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.predicate.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangePropertyForEachChildrenTask
extends AbstractRepositoryTask {
    private final String workspaceName;
    private final String nodePath;
    private final String propertyName;
    private final Object newPropertyValue;
    private final Object previousPropertyValue;
    private Logger log = LoggerFactory.getLogger(ChangePropertyForEachChildrenTask.class);

    public ChangePropertyForEachChildrenTask(String workspaceName, String nodePath, String propertyName, Object previousPropertyValue, Object newPropertyValue) {
        super("Checking the value of " + nodePath + "/*/" + propertyName, "Creating property " + nodePath + "/*/" + propertyName + " and setting its value to " + newPropertyValue + " if the previous value is " + previousPropertyValue);
        this.workspaceName = workspaceName;
        this.nodePath = nodePath;
        this.propertyName = propertyName;
        this.previousPropertyValue = previousPropertyValue;
        this.newPropertyValue = newPropertyValue;
    }

    protected void doExecute(InstallContext ctx) throws RepositoryException, TaskExecutionException {
        Session hm = ctx.getJCRSession(this.workspaceName);
        Node parentnode = NodeUtilsExt.getNodeIfExists(hm, this.nodePath);
        if (parentnode == null) {
            this.log.info("Node {} not found, nothing to do", (Object)this.nodePath);
            return;
        }
        Iterable children = NodeUtil.getNodes((Node)parentnode, (Predicate)NodeUtil.EXCLUDE_META_DATA_FILTER);
        for (Node node : children) {
            NodeUtilsExt.setPropertyIfDifferentFromValue(node, this.propertyName, this.newPropertyValue, this.previousPropertyValue);
        }
    }
}

