/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractTask;
import info.magnolia.module.delta.Task;
import info.magnolia.module.delta.TaskExecutionException;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public abstract class ConditionalTask
extends AbstractTask {
    protected String workspace;
    protected String handle;
    protected List<Task> tasks;

    public ConditionalTask(String workspace, String handle, List<Task> tasks) {
        super("Conditional task", "Execute task if exists " + handle + " in " + workspace);
        this.tasks = tasks;
        this.handle = handle;
        this.workspace = workspace;
    }

    public void execute(InstallContext installContext) throws TaskExecutionException {
        try {
            Session session = installContext.getJCRSession(this.workspace);
            if (this.verifyCondition(session, this.handle)) {
                for (Task t : this.tasks) {
                    t.execute(installContext);
                }
            }
        }
        catch (RepositoryException e) {
            throw new TaskExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    public abstract boolean verifyCondition(Session var1, String var2) throws RepositoryException;
}

