/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.jcr.util.NodeUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.TaskExecutionException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDefaultRepositoryAclForAllUsersTask
extends AbstractRepositoryTask {
    private static Logger log = LoggerFactory.getLogger(CreateDefaultRepositoryAclForAllUsersTask.class);
    private String repository;
    private long permissions;

    public CreateDefaultRepositoryAclForAllUsersTask(String repository, long permissions) {
        super("Adding permissions on " + repository + " repository", "Adding permissions on " + repository + " repository");
        this.repository = repository;
        this.permissions = permissions;
    }

    protected void doExecute(InstallContext ctx) throws RepositoryException, TaskExecutionException {
        Session hm = ctx.getJCRSession("userroles");
        Node parentNode = hm.getRootNode();
        Iterable childNodes = NodeUtil.getNodes((Node)parentNode, (String)"mgnl:role");
        for (Node content : childNodes) {
            this.operateOnChildNode(content, ctx);
        }
    }

    protected void operateOnChildNode(Node node, InstallContext ctx) throws RepositoryException {
        String aclpath = "acl_" + this.repository;
        if (!node.hasNode(aclpath)) {
            log.info("adding permissions on {} to role {}", (Object)this.repository, (Object)node.getName());
            Node aclnode = node.addNode(aclpath, "mgnl:contentNode");
            Node permNode = aclnode.addNode("0", "mgnl:contentNode");
            permNode.setProperty("path", "/*");
            permNode.setProperty("permissions", this.permissions);
        }
    }
}

