/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.TaskExecutionException;
import it.openutils.mgnlutils.util.NodeUtilsExt;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteNodeTask
extends AbstractRepositoryTask {
    private String workspaceName;
    private String nodePath;
    private String warning;
    private Logger log = LoggerFactory.getLogger(DeleteNodeTask.class);

    public DeleteNodeTask(String workspaceName, String nodePath, String warning) {
        super("Deleting the node " + nodePath, "Deleting the node " + nodePath);
        this.workspaceName = workspaceName;
        this.nodePath = nodePath;
        this.warning = warning;
    }

    public DeleteNodeTask(String workspaceName, String nodePath) {
        this(workspaceName, nodePath, null);
    }

    protected void doExecute(InstallContext installContext) throws RepositoryException, TaskExecutionException {
        Session session = installContext.getJCRSession(this.workspaceName);
        if (NodeUtilsExt.exists(session, this.nodePath)) {
            if (this.warning != null) {
                installContext.warn(this.warning);
            }
            NodeUtilsExt.deleteIfExisting(session, this.nodePath);
        }
    }
}

