/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.importexport.DataTransporter;
import info.magnolia.jcr.util.NodeUtil;
import info.magnolia.module.InstallContext;
import it.openutils.mgnltasks.ModuleConfigBootstrapTask;
import it.openutils.mgnlutils.util.NodeUtilsExt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffModuleConfigBootstrapTask
extends ModuleConfigBootstrapTask {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public DiffModuleConfigBootstrapTask(String modulename) {
        super(modulename);
    }

    public DiffModuleConfigBootstrapTask(String modulename, Set<String> includedRepositories) {
        super(modulename, includedRepositories);
    }

    @Override
    protected boolean skipResource(InstallContext installContext, String name) throws RepositoryException {
        boolean unchanged = this.bootstrapResourceEqualsExisting(installContext, name);
        if (unchanged) {
            this.log.debug("Skipping file {}", (Object)name);
        }
        return unchanged;
    }

    @Override
    protected void deleteNode(InstallContext installContext, String nodePath) throws RepositoryException {
        Session hm = installContext.getJCRSession("config");
        if (NodeUtilsExt.exists(hm, nodePath)) {
            Node node = hm.getNode(nodePath);
            HashSet<String> lookup = new HashSet<String>();
            for (String name : this.resourcesToBootstrap) {
                String[] repositoryAndPath = this.getRepositoryAndPathFromBootstrapName(name);
                if (!"config".equals(repositoryAndPath[0]) || !StringUtils.startsWith((String)repositoryAndPath[1], (String)nodePath)) continue;
                lookup.add(name);
            }
            for (Node childNode : NodeUtil.getNodes((Node)node, (String)"mgnl:contentNode")) {
                String fileName = childNode.getSession().getWorkspace().getName() + childNode.getPath().replace("/", ".") + ".xml";
                String resourceToBootstrap = "/mgnl-bootstrap/" + this.modulename + "/" + fileName;
                if (lookup.contains(resourceToBootstrap)) continue;
                this.log.warn("Deleting node {}", (Object)childNode.getPath());
                childNode.remove();
            }
        }
    }

    private String[] getRepositoryAndPathFromBootstrapName(String resourceName) {
        String fullPath;
        resourceName = StringUtils.replace((String)resourceName, (String)"\\", (String)"/");
        String name = StringUtils.removeEnd((String)StringUtils.substringAfterLast((String)resourceName, (String)"/"), (String)".xml");
        String repository = StringUtils.substringBefore((String)name, (String)".");
        String pathName = StringUtils.substringAfter((String)StringUtils.substringBeforeLast((String)name, (String)"."), (String)".");
        String nodeName = StringUtils.substringAfterLast((String)name, (String)".");
        if (StringUtils.isEmpty((String)pathName)) {
            pathName = "/";
            fullPath = "/" + nodeName;
        } else {
            pathName = "/" + StringUtils.replace((String)pathName, (String)".", (String)"/");
            fullPath = pathName + "/" + nodeName;
        }
        return new String[]{repository, fullPath};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bootstrapResourceEqualsExisting(InstallContext installContext, String name) throws RepositoryException {
        String[] repositoryAndPath = this.getRepositoryAndPathFromBootstrapName(name);
        String repository = repositoryAndPath[0];
        String path = repositoryAndPath[1];
        Node content = NodeUtilsExt.getNodeIfExists(installContext.getJCRSession(repository), path);
        if (content != null) {
            File file = null;
            try {
                String filenameWithoutExtension = StringUtils.removeEnd((String)StringUtils.substringAfterLast((String)name, (String)"/"), (String)".xml");
                file = this.exportToTempFile(content, filenameWithoutExtension);
            }
            catch (Exception e) {
                this.log.warn("Cannot export content " + path + " from repository " + repository, (Throwable)e);
            }
            if (file != null) {
                try {
                    InputStream boostrapStream = ((Object)((Object)this)).getClass().getResourceAsStream(name);
                    FileInputStream existingStream = new FileInputStream(file);
                    boolean bl = IOUtils.contentEquals((InputStream)boostrapStream, (InputStream)existingStream);
                    return bl;
                }
                catch (IOException e) {
                    this.log.warn("Cannot compare bootstrap resource " + name + " with the existing one", (Throwable)e);
                }
                finally {
                    file.delete();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File exportToTempFile(Node content, String filenameWithoutExtension) throws IOException, FileNotFoundException, RepositoryException {
        File file = File.createTempFile(filenameWithoutExtension + '-', ".xml");
        FileOutputStream out = new FileOutputStream(file);
        try {
            DataTransporter.executeExport((OutputStream)out, (boolean)false, (boolean)true, (Session)content.getSession(), (String)content.getPath(), (String)content.getSession().getWorkspace().getName(), (String)".xml");
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
        return file;
    }
}

