/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.jcr.RuntimeRepositoryException;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.BootstrapResourcesTask;
import it.openutils.mgnltasks.AnonymousUserSetupTask;
import it.openutils.mgnlutils.util.NodeUtilsExt;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExistenceConditionalBootstrapTask
extends BootstrapResourcesTask {
    private String workspace;
    private String folderName;
    private Logger log = LoggerFactory.getLogger(AnonymousUserSetupTask.class);

    public ExistenceConditionalBootstrapTask(String workspace, String folderName, int importUUIDBehavior) {
        super("ExistenceConditionalBootstrap", "ExistenceConditionalBootstrap", importUUIDBehavior);
        this.workspace = workspace;
        this.folderName = folderName;
    }

    public ExistenceConditionalBootstrapTask(String workspace, String folderName) {
        super("Loading new content", "Bootstrap of new configuration in " + folderName);
        this.workspace = workspace;
        this.folderName = folderName;
    }

    protected boolean acceptResource(InstallContext installContext, String name) {
        boolean accept;
        boolean bl = accept = name.startsWith("/mgnl-bootstrap/" + this.folderName + "/" + this.workspace) && name.endsWith(".xml");
        if (accept) {
            Session session;
            String handle = StringUtils.substringAfter((String)name, (String)("/mgnl-bootstrap/" + this.folderName + "/" + this.workspace + "."));
            handle = StringUtils.substringBeforeLast((String)handle, (String)".xml");
            handle = "/" + StringUtils.replace((String)handle, (String)".", (String)"/");
            try {
                session = installContext.getJCRSession(this.workspace);
            }
            catch (RepositoryException e) {
                throw new RuntimeRepositoryException(e);
            }
            boolean alreadyExisting = NodeUtilsExt.exists(session, handle);
            if (!alreadyExisting) {
                this.log.info("Loading {} since no content at {}:{} has been found", new Object[]{name, this.workspace, handle});
            }
            return !alreadyExisting;
        }
        return false;
    }

    protected String[] getResourcesToBootstrap(InstallContext installContext) {
        return super.getResourcesToBootstrap(installContext);
    }
}

