/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.importexport.BootstrapUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.BootstrapResourcesTask;
import info.magnolia.module.delta.TaskExecutionException;
import it.openutils.mgnlutils.util.NodeUtilsExt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleConfigBootstrapTask
extends BootstrapResourcesTask {
    private Logger log = LoggerFactory.getLogger(ModuleConfigBootstrapTask.class);
    protected String modulename;
    protected Set<String> includedRepositories = new HashSet<String>();
    protected String[] resourcesToBootstrap;

    public ModuleConfigBootstrapTask(String modulename) {
        super("Bootstrap", "Bootstraps module configuration for " + modulename + " (config repository only).");
        this.modulename = modulename;
        this.includedRepositories.add("config");
    }

    public ModuleConfigBootstrapTask(String modulename, Set<String> includedRepositories) {
        super("Bootstrap", "Bootstraps module configuration for " + modulename + " (will bootstrap config and " + includedRepositories + " repositories).");
        this.modulename = modulename;
        this.includedRepositories.addAll(includedRepositories);
    }

    protected boolean acceptResource(InstallContext ctx, String name) {
        boolean accept = false;
        for (String repository : this.includedRepositories) {
            if (!name.startsWith("/mgnl-bootstrap/" + this.modulename + "/" + repository + ".")) continue;
            accept = true;
            break;
        }
        if (accept) {
            this.log.debug("Importing file {}", (Object)name);
        }
        return accept;
    }

    public void execute(InstallContext installContext) throws TaskExecutionException {
        try {
            this.resourcesToBootstrap = this.getResourcesToBootstrap(installContext);
            long millis = System.currentTimeMillis();
            this.log.info("{} bootstrap starting...", (Object)this.modulename);
            this.deleteNode(installContext, "/modules/" + this.modulename + "/dialogs");
            this.deleteNode(installContext, "/modules/" + this.modulename + "/templates");
            this.deleteNode(installContext, "/modules/" + this.modulename + "/paragraphs");
            this.deleteNode(installContext, "/modules/" + this.modulename + "/virtualURIMapping");
            ArrayList<String> filteredResources = new ArrayList<String>();
            for (String name : this.resourcesToBootstrap) {
                if (this.skipResource(installContext, name)) continue;
                filteredResources.add(name);
            }
            BootstrapUtil.bootstrap((String[])filteredResources.toArray(new String[0]), (int)1);
            this.log.info("{} bootstrap done in {} seconds", (Object)this.modulename, (Object)((System.currentTimeMillis() - millis) / 1000L));
        }
        catch (IOException e) {
            throw new TaskExecutionException("Could not bootstrap: " + e.getMessage());
        }
        catch (RepositoryException e) {
            throw new TaskExecutionException("Could not bootstrap: " + e.getMessage());
        }
    }

    protected boolean skipResource(InstallContext installContext, String name) throws RepositoryException {
        return false;
    }

    protected void deleteNode(InstallContext installContext, String nodePath) throws RepositoryException {
        Session hm = installContext.getJCRSession("config");
        if (NodeUtilsExt.deleteIfExisting(hm, nodePath)) {
            this.log.warn("Deleted node {}", (Object)nodePath);
        }
    }
}

