/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.jcr.util.NodeUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.TaskExecutionException;
import it.openutils.mgnlutils.util.NodeUtilsExt;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.predicate.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveSubnodesAndDeleteTask
extends AbstractRepositoryTask {
    private String workspaceName;
    private String from;
    private String warning;
    private Logger log = LoggerFactory.getLogger(MoveSubnodesAndDeleteTask.class);
    private String to;

    public MoveSubnodesAndDeleteTask(String workspaceName, String from, String to, String warning) {
        super("Moving configuration from " + from + " to " + to, "Moving configuration from " + from + " to " + to);
        this.workspaceName = workspaceName;
        this.from = from;
        this.to = to;
        this.warning = warning;
    }

    protected void doExecute(InstallContext installContext) throws RepositoryException, TaskExecutionException {
        Session session = installContext.getJCRSession(this.workspaceName);
        if (NodeUtilsExt.exists(session, this.from)) {
            if (this.warning != null) {
                installContext.warn(this.warning);
            }
            Node fromnode = session.getNode(this.from);
            Node toNode = null;
            toNode = !NodeUtilsExt.exists(session, this.to) ? NodeUtil.createPath((Node)session.getRootNode(), (String)this.to, (String)"mgnl:content") : session.getNode(this.to);
            Iterable nodes = NodeUtil.getNodes((Node)fromnode, (Predicate)NodeUtil.EXCLUDE_META_DATA_FILTER);
            for (Node node : nodes) {
                if (toNode.hasNode(node.getName())) continue;
                node.getSession().move(node.getPath(), toNode.getPath() + "/" + node.getName());
            }
            NodeUtilsExt.deleteIfExisting(session, this.from);
        }
    }
}

